/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceContractImpl;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceImpl;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceIntrospectorImpl;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaInterfaceFactoryImpl
implements JavaInterfaceFactory {
    private List<JavaInterfaceVisitor> visitors = new ArrayList<JavaInterfaceVisitor>();
    private JavaInterfaceIntrospectorImpl introspector = new JavaInterfaceIntrospectorImpl(this);

    @Override
    public JavaInterface createJavaInterface() {
        return new JavaInterfaceImpl();
    }

    @Override
    public JavaInterface createJavaInterface(Class<?> interfaceClass) throws InvalidInterfaceException {
        JavaInterface javaInterface = this.createJavaInterface();
        this.introspector.introspectInterface(javaInterface, interfaceClass);
        return javaInterface;
    }

    @Override
    public void createJavaInterface(JavaInterface javaInterface, Class<?> interfaceClass) throws InvalidInterfaceException {
        this.introspector.introspectInterface(javaInterface, interfaceClass);
    }

    @Override
    public JavaInterfaceContract createJavaInterfaceContract() {
        return new JavaInterfaceContractImpl();
    }

    @Override
    public void addInterfaceVisitor(JavaInterfaceVisitor extension) {
        this.visitors.add(extension);
    }

    @Override
    public void removeInterfaceVisitor(JavaInterfaceVisitor extension) {
        this.visitors.remove(extension);
    }

    @Override
    public List<JavaInterfaceVisitor> getInterfaceVisitors() {
        return this.visitors;
    }
}

