/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceFactoryImpl;
import org.apache.tuscany.sca.interfacedef.java.impl.PolicyJavaInterfaceVisitor;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaInterfaceFactory
extends JavaInterfaceFactoryImpl
implements JavaInterfaceFactory {
    private ModelFactoryExtensionPoint modelFactoryExtensionPoint;
    private boolean loadedVisitors;

    public DefaultJavaInterfaceFactory() {
    }

    public DefaultJavaInterfaceFactory(ModelFactoryExtensionPoint modelFactoryExtensionPoint) {
        this.modelFactoryExtensionPoint = modelFactoryExtensionPoint;
    }

    @Override
    public List<JavaInterfaceVisitor> getInterfaceVisitors() {
        this.loadVisitors();
        return super.getInterfaceVisitors();
    }

    private void loadVisitors() {
        Set visitorDeclarations;
        PolicyFactory policyFactory;
        if (this.loadedVisitors) {
            return;
        }
        if (this.modelFactoryExtensionPoint != null && (policyFactory = (PolicyFactory)this.modelFactoryExtensionPoint.getFactory(PolicyFactory.class)) != null) {
            this.addInterfaceVisitor(new PolicyJavaInterfaceVisitor(policyFactory));
        }
        try {
            visitorDeclarations = ServiceDiscovery.getInstance().getServiceDeclarations(JavaInterfaceVisitor.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration visitorDeclaration : visitorDeclarations) {
            JavaInterfaceVisitor visitor;
            try {
                Class visitorClass = visitorDeclaration.loadClass();
                visitor = (JavaInterfaceVisitor)visitorClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            this.addInterfaceVisitor(visitor);
        }
        this.loadedVisitors = true;
    }
}

