/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.jaxws;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;

public class JAXWSAsyncInterfaceProcessor
implements JavaInterfaceVisitor {
    private static String ASYNC = "Async";

    public JAXWSAsyncInterfaceProcessor(ExtensionPointRegistry registry) {
    }

    public void visitInterface(JavaInterface javaInterface) throws InvalidInterfaceException {
        ArrayList validOperations = new ArrayList();
        ArrayList<Operation> asyncOperations = new ArrayList<Operation>();
        validOperations.addAll(javaInterface.getOperations());
        for (Operation o : javaInterface.getOperations()) {
            JavaOperation op;
            if (o.getName().endsWith(ASYNC) || (op = (JavaOperation)o).getJavaMethod().getName().endsWith(ASYNC)) continue;
            for (Operation asyncOp : JAXWSAsyncInterfaceProcessor.getAsyncOperations(javaInterface.getOperations(), op)) {
                if (!JAXWSAsyncInterfaceProcessor.isJAXWSAsyncPoolingOperation((Operation)op, asyncOp) && !JAXWSAsyncInterfaceProcessor.isJAXWSAsyncCallbackOperation((Operation)op, asyncOp)) continue;
                validOperations.remove(asyncOp);
                asyncOperations.add(asyncOp);
            }
        }
        javaInterface.getOperations().clear();
        javaInterface.getOperations().addAll(validOperations);
        javaInterface.getAttributes().put("JAXWS-ASYNC-OPERATIONS", asyncOperations);
    }

    private static boolean isJAXWSAsyncPoolingOperation(Operation operation, Operation asyncOperation) {
        Class asyncReturnTypeClass;
        if (((List)asyncOperation.getOutputType().getLogical()).size() == 0 || Response.class != ((DataType)((List)asyncOperation.getOutputType().getLogical()).get(0)).getPhysical()) {
            return false;
        }
        List operationInputType = (List)operation.getInputType().getLogical();
        List asyncOperationInputType = (List)asyncOperation.getInputType().getLogical();
        int size = operationInputType.size();
        if (asyncOperationInputType.size() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (JAXWSAsyncInterfaceProcessor.isCompatible((DataType)operationInputType.get(i), (DataType)asyncOperationInputType.get(i))) continue;
            return false;
        }
        DataType operationOutputType = null;
        if (operation.getOutputType() != null && operation.getOutputType().getLogical() != null && ((List)operation.getOutputType().getLogical()).size() > 0) {
            operationOutputType = (DataType)((List)operation.getOutputType().getLogical()).get(0);
        }
        DataType asyncOperationOutputType = (DataType)((List)asyncOperation.getOutputType().getLogical()).get(0);
        if (operationOutputType != null && asyncOperationOutputType != null && (asyncReturnTypeClass = asyncOperationOutputType.getPhysical()) == Response.class) {
            Class wrapperClass;
            Class returnType = operationOutputType.getPhysical();
            Class asyncActualReturnTypeClass = Object.class;
            if (asyncOperationOutputType.getGenericType() instanceof ParameterizedType) {
                ParameterizedType asyncReturnType = (ParameterizedType)asyncOperationOutputType.getGenericType();
                asyncActualReturnTypeClass = (Class)asyncReturnType.getActualTypeArguments()[0];
            }
            if (operation.getOutputWrapper() != null && (wrapperClass = operation.getOutputWrapper().getWrapperClass()) == asyncActualReturnTypeClass) {
                return true;
            }
            return returnType == asyncActualReturnTypeClass || returnType.isPrimitive() && JAXWSAsyncInterfaceProcessor.primitiveAssignable(returnType, asyncActualReturnTypeClass);
        }
        return true;
    }

    private static boolean isJAXWSAsyncCallbackOperation(Operation operation, Operation asyncOperation) {
        if (((List)asyncOperation.getOutputType().getLogical()).size() == 0 || Future.class != ((DataType)((List)asyncOperation.getOutputType().getLogical()).get(0)).getPhysical()) {
            return false;
        }
        List operationInputType = (List)operation.getInputType().getLogical();
        List asyncOperationInputType = (List)asyncOperation.getInputType().getLogical();
        int size = operationInputType.size();
        if (asyncOperationInputType.size() != size + 1) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (JAXWSAsyncInterfaceProcessor.isCompatible((DataType)operationInputType.get(i), (DataType)asyncOperationInputType.get(i))) continue;
            return false;
        }
        Type genericParamType = ((DataType)asyncOperationInputType.get(size)).getGenericType();
        Class asyncLastParameterTypeClass = ((DataType)asyncOperationInputType.get(size)).getPhysical();
        if (asyncLastParameterTypeClass == AsyncHandler.class) {
            Class wrapperClass;
            Class asyncActualLastParameterTypeClass = Object.class;
            if (genericParamType instanceof ParameterizedType) {
                ParameterizedType asyncLastParameterType = (ParameterizedType)genericParamType;
                asyncActualLastParameterTypeClass = (Class)asyncLastParameterType.getActualTypeArguments()[0];
            }
            if (operation.getOutputWrapper() != null && (wrapperClass = operation.getOutputWrapper().getWrapperClass()) == asyncActualLastParameterTypeClass) {
                return true;
            }
            Class returnType = null;
            if (operation.getOutputType() != null && operation.getOutputType().getLogical() != null && ((List)operation.getOutputType().getLogical()).size() > 0) {
                returnType = ((DataType)((List)operation.getOutputType().getLogical()).get(0)).getPhysical();
            }
            return returnType != null && (returnType == asyncActualLastParameterTypeClass || returnType.isPrimitive() && JAXWSAsyncInterfaceProcessor.primitiveAssignable(returnType, asyncActualLastParameterTypeClass));
        }
        return true;
    }

    private static List<Operation> getAsyncOperations(List<Operation> operations, JavaOperation op) {
        ArrayList<Operation> returnOperations = new ArrayList<Operation>();
        for (Operation o : operations) {
            if (o == op) continue;
            String operationName = op.getName();
            if (o.getName().equals(operationName)) {
                returnOperations.add(o);
                continue;
            }
            if (!o.getName().equals(operationName + ASYNC)) continue;
            returnOperations.add(o);
        }
        return returnOperations;
    }

    private static boolean isCompatible(DataType<?> source, DataType<?> target) {
        if (source == target) {
            return true;
        }
        return target.getPhysical().isAssignableFrom(source.getPhysical());
    }

    private static boolean primitiveAssignable(Class<?> memberType, Class<?> param) {
        if (memberType == Integer.class) {
            return param == Integer.TYPE;
        }
        if (memberType == Double.class) {
            return param == Double.TYPE;
        }
        if (memberType == Float.class) {
            return param == Float.TYPE;
        }
        if (memberType == Short.class) {
            return param == Short.TYPE;
        }
        if (memberType == Character.class) {
            return param == Character.TYPE;
        }
        if (memberType == Boolean.class) {
            return param == Boolean.TYPE;
        }
        if (memberType == Byte.class) {
            return param == Byte.TYPE;
        }
        if (param == Integer.class) {
            return memberType == Integer.TYPE;
        }
        if (param == Double.class) {
            return memberType == Double.TYPE;
        }
        if (param == Float.class) {
            return memberType == Float.TYPE;
        }
        if (param == Short.class) {
            return memberType == Short.TYPE;
        }
        if (param == Character.class) {
            return memberType == Character.TYPE;
        }
        if (param == Boolean.class) {
            return memberType == Boolean.TYPE;
        }
        if (param == Byte.class) {
            return memberType == Byte.TYPE;
        }
        return false;
    }
}

