/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.jaxws;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.ws.Holder;
import org.apache.tuscany.sca.databinding.jaxb.XMLAdapterExtensionPoint;
import org.apache.tuscany.sca.interfacedef.java.jaxws.CodeGenerationHelper;
import org.apache.tuscany.sca.interfacedef.java.jaxws.GeneratedClassLoader;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public abstract class BaseBeanGenerator
implements Opcodes {
    private static final Map<String, String> COLLECTION_CLASSES = new HashMap<String, String>();
    private static final Class[] KNOWN_JAXB_ANNOTATIONS;
    private static final Map<String, String> JAVA_KEYWORDS;
    protected static final Map<Object, WeakReference<Class<?>>> generatedClasses;
    protected XMLAdapterExtensionPoint xmlAdapters;

    public byte[] defineClass(ClassWriter cw, String classDescriptor, String classSignature, String namespace, String name, BeanProperty[] properties) {
        this.declareClass(cw, classDescriptor);
        String[] propOrder = null;
        if (properties != null && properties.length > 0) {
            int size = properties.length;
            propOrder = new String[size];
            for (int i = 0; i < size; ++i) {
                propOrder[i] = this.getFieldName(properties[i].getName());
            }
        }
        this.annotateClass(cw, name, namespace, propOrder);
        this.declareConstructor(cw, classSignature);
        if (properties != null) {
            for (BeanProperty p : properties) {
                Class adapterClass;
                boolean isElement = p.isElement() && !Map.class.isAssignableFrom(p.getType());
                String xmlAdapterClassSignature = null;
                if (this.xmlAdapters != null && (adapterClass = this.xmlAdapters.getAdapter(p.getType())) != null) {
                    xmlAdapterClassSignature = CodeGenerationHelper.getSignature(adapterClass);
                }
                this.declareProperty(cw, classDescriptor, classSignature, p.getName(), p.getSignature(), p.getGenericSignature(), isElement, p.isNillable(), xmlAdapterClassSignature, p.getJaxbAnnotaions());
            }
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected static boolean isHolder(Type type) {
        if (type instanceof ParameterizedType) {
            Class<?> cls = CodeGenerationHelper.getErasure(type);
            return cls == Holder.class;
        }
        return false;
    }

    protected static Type getHolderValueType(Type paramType) {
        ParameterizedType p;
        Class<?> cls;
        if (paramType instanceof ParameterizedType && (cls = CodeGenerationHelper.getErasure(p = (ParameterizedType)paramType)) == Holder.class) {
            return p.getActualTypeArguments()[0];
        }
        return paramType;
    }

    protected void declareProperty(ClassWriter cw, String classDescriptor, String classSignature, String propName, String propClassSignature, String propTypeSignature, boolean isElement, boolean isNillable, String xmlAdapterClassSignature, List<Annotation> jaxbAnnotations) {
        if (propClassSignature.equals(propTypeSignature)) {
            propTypeSignature = null;
        }
        this.declareField(cw, propName, propClassSignature, propTypeSignature, isElement, isNillable, xmlAdapterClassSignature, jaxbAnnotations);
        this.decalreGetter(cw, classDescriptor, classSignature, propName, propClassSignature, propTypeSignature);
        this.declareSetter(cw, classDescriptor, classSignature, propName, propClassSignature, propTypeSignature);
    }

    protected String getFieldName(String propName) {
        String name = JAVA_KEYWORDS.get(propName);
        return name != null ? name : propName;
    }

    protected void declareField(ClassWriter cw, String propName, String propClassSignature, String propTypeSignature, boolean isElement, boolean isNillable, String xmlAdapterClassSignature, List<Annotation> jaxbAnnotations) {
        AnnotationVisitor av0;
        FieldVisitor fv = cw.visitField(4, this.getFieldName(propName), propClassSignature, propTypeSignature, null);
        if (isElement && xmlAdapterClassSignature == null) {
            av0 = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlElement;", true);
            av0.visit("name", (Object)propName);
            av0.visit("namespace", (Object)"");
            if (isNillable) {
                av0.visit("nillable", (Object)Boolean.TRUE);
            } else {
                av0.visit("nillable", (Object)Boolean.FALSE);
            }
            av0.visitEnd();
        }
        if (xmlAdapterClassSignature != null) {
            av0 = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlAnyElement;", true);
            av0.visit("lax", (Object)Boolean.TRUE);
            av0.visitEnd();
            av0 = fv.visitAnnotation("Ljavax/xml/bind/annotation/adapters/XmlJavaTypeAdapter;", true);
            av0.visit("value", (Object)org.objectweb.asm.Type.getType((String)xmlAdapterClassSignature));
            av0.visitEnd();
        }
        for (Annotation ann : jaxbAnnotations) {
            if (ann instanceof XmlMimeType) {
                AnnotationVisitor mime = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlMimeType;", true);
                mime.visit("value", (Object)((XmlMimeType)ann).value());
                mime.visitEnd();
                continue;
            }
            if (ann instanceof XmlJavaTypeAdapter) {
                AnnotationVisitor ada = fv.visitAnnotation("Ljavax/xml/bind/annotation/adapters/XmlJavaTypeAdapter;", true);
                ada.visit("value", (Object)org.objectweb.asm.Type.getType((Class)((XmlJavaTypeAdapter)ann).value()));
                ada.visit("type", (Object)org.objectweb.asm.Type.getType((Class)((XmlJavaTypeAdapter)ann).type()));
                ada.visitEnd();
                continue;
            }
            if (ann instanceof XmlAttachmentRef) {
                AnnotationVisitor att = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlAttachmentRef;", true);
                att.visitEnd();
                continue;
            }
            if (!(ann instanceof XmlList)) continue;
            AnnotationVisitor list = fv.visitAnnotation("Ljavax/xml/bind/annotation/XmlList;", true);
            list.visitEnd();
        }
        fv.visitEnd();
    }

    protected void declareSetter(ClassWriter cw, String classDescriptor, String classSignature, String propName, String propClassSignature, String propTypeSignature) {
        if ("Ljava/util/List;".equals(propClassSignature)) {
            return;
        }
        MethodVisitor mv = cw.visitMethod(1, "set" + BaseBeanGenerator.capitalize(propName), "(" + propClassSignature + ")V", propTypeSignature == null ? null : "(" + propTypeSignature + ")V", null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(CodeGenerationHelper.getLoadOPCode(propClassSignature), 1);
        mv.visitFieldInsn(181, classDescriptor, this.getFieldName(propName), propClassSignature);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitInsn(177);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLocalVariable("this", classSignature, null, l0, l2, 0);
        mv.visitLocalVariable(this.getFieldName(propName), propClassSignature, propTypeSignature, l0, l2, 1);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
    }

    protected void decalreGetter(ClassWriter cw, String classDescriptor, String classSignature, String propName, String propClassSignature, String propTypeSignature) {
        String collectionImplClass = COLLECTION_CLASSES.get(propClassSignature);
        if (collectionImplClass != null) {
            this.decalreCollectionGetter(cw, classDescriptor, classSignature, propName, propClassSignature, propTypeSignature, collectionImplClass);
            return;
        }
        String getterName = ("Z".equals(propClassSignature) ? "is" : "get") + BaseBeanGenerator.capitalize(propName);
        MethodVisitor mv = cw.visitMethod(1, getterName, "()" + propClassSignature, propTypeSignature == null ? null : "()" + propTypeSignature, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, classDescriptor, this.getFieldName(propName), propClassSignature);
        mv.visitInsn(CodeGenerationHelper.getReturnOPCode(propClassSignature));
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", classSignature, null, l0, l1, 0);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    protected void decalreCollectionGetter(ClassWriter cw, String classDescriptor, String classSignature, String propName, String propClassSignature, String propTypeSignature, String collectionImplClass) {
        String getterName = "get" + BaseBeanGenerator.capitalize(propName);
        String fieldName = this.getFieldName(propName);
        MethodVisitor mv = cw.visitMethod(1, getterName, "()" + propClassSignature, propTypeSignature == null ? null : "()" + propTypeSignature, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(63, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, classDescriptor, fieldName, propClassSignature);
        Label l1 = new Label();
        mv.visitJumpInsn(199, l1);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(64, l2);
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, collectionImplClass);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, collectionImplClass, "<init>", "()V");
        mv.visitFieldInsn(181, classDescriptor, fieldName, propClassSignature);
        mv.visitLabel(l1);
        mv.visitLineNumber(66, l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, classDescriptor, fieldName, propClassSignature);
        mv.visitInsn(176);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", classSignature, null, l0, l3, 0);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
    }

    protected static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    protected void declareConstructor(ClassWriter cw, String classSignature) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", classSignature, null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    protected void declareClass(ClassWriter cw, String classDescriptor) {
        cw.visit(49, 33, classDescriptor, null, "java/lang/Object", null);
    }

    protected void annotateClass(ClassWriter cw, String name, String namespace, String[] propOrder) {
        AnnotationVisitor av0 = cw.visitAnnotation("Ljavax/xml/bind/annotation/XmlRootElement;", true);
        av0.visit("name", (Object)name);
        av0.visit("namespace", (Object)namespace);
        av0.visitEnd();
        av0 = cw.visitAnnotation("Ljavax/xml/bind/annotation/XmlAccessorType;", true);
        av0.visitEnum("value", "Ljavax/xml/bind/annotation/XmlAccessType;", "FIELD");
        av0.visitEnd();
        av0 = cw.visitAnnotation("Ljavax/xml/bind/annotation/XmlType;", true);
        av0.visit("name", (Object)name);
        av0.visit("namespace", (Object)namespace);
        if (propOrder != null) {
            AnnotationVisitor pv = av0.visitArray("propOrder");
            for (String p : propOrder) {
                pv.visit(null, (Object)p);
            }
            pv.visitEnd();
        }
        av0.visitEnd();
    }

    public Class<?> generate(String classDescriptor, String classSignature, String namespace, String name, BeanProperty[] properties, GeneratedClassLoader classLoader) {
        ClassWriter cw;
        try {
            Constructor c = ClassWriter.class.getConstructor(Integer.TYPE);
            Field f = ClassWriter.class.getField("COMPUTE_MAXS");
            cw = (ClassWriter)c.newInstance(f.get(null));
        }
        catch (Exception ex) {
            try {
                Constructor c = ClassWriter.class.getConstructor(Boolean.TYPE);
                cw = (ClassWriter)c.newInstance(true);
            }
            catch (Exception ex2) {
                throw new IllegalArgumentException(ex2);
            }
        }
        byte[] byteCode = this.defineClass(cw, classDescriptor, classSignature, namespace, name, properties);
        String className = classDescriptor.replace('/', '.');
        Class<?> generated = classLoader.getGeneratedClass(className, byteCode);
        return generated;
    }

    public XMLAdapterExtensionPoint getXmlAdapters() {
        return this.xmlAdapters;
    }

    public void setXmlAdapters(XMLAdapterExtensionPoint xmlAdapters) {
        this.xmlAdapters = xmlAdapters;
    }

    protected static <T extends Annotation> T findAnnotation(Annotation[] anns, Class<T> annotationClass) {
        for (Annotation a : anns) {
            if (a.annotationType() != annotationClass) continue;
            return (T)((Annotation)annotationClass.cast(a));
        }
        return null;
    }

    protected static List<Annotation> findJAXBAnnotations(Annotation[] anns) {
        ArrayList<Annotation> jaxbAnnotation = new ArrayList<Annotation>();
        for (Class c : KNOWN_JAXB_ANNOTATIONS) {
            Object a = BaseBeanGenerator.findAnnotation(anns, c);
            if (a == null) continue;
            jaxbAnnotation.add((Annotation)a);
        }
        return jaxbAnnotation;
    }

    protected List<Annotation> findJAXBAnnotations(Method method) {
        ArrayList<Annotation> anns = new ArrayList<Annotation>();
        for (Class c : KNOWN_JAXB_ANNOTATIONS) {
            Object ann = method.getAnnotation(c);
            if (ann == null) continue;
            anns.add((Annotation)ann);
        }
        return anns;
    }

    static {
        COLLECTION_CLASSES.put("Ljava/util/Collection;", "java/util/ArrayList");
        COLLECTION_CLASSES.put("Ljava/util/List;", "java/util/ArrayList");
        COLLECTION_CLASSES.put("Ljava/util/Set;", "java/util/HashSet");
        COLLECTION_CLASSES.put("Ljava/util/Queue;", "java/util/LinkedList");
        KNOWN_JAXB_ANNOTATIONS = new Class[]{XmlAttachmentRef.class, XmlMimeType.class, XmlJavaTypeAdapter.class, XmlList.class};
        JAVA_KEYWORDS = new HashMap<String, String>();
        JAVA_KEYWORDS.put("abstract", "_abstract");
        JAVA_KEYWORDS.put("assert", "_assert");
        JAVA_KEYWORDS.put("boolean", "_boolean");
        JAVA_KEYWORDS.put("break", "_break");
        JAVA_KEYWORDS.put("byte", "_byte");
        JAVA_KEYWORDS.put("case", "_case");
        JAVA_KEYWORDS.put("catch", "_catch");
        JAVA_KEYWORDS.put("char", "_char");
        JAVA_KEYWORDS.put("class", "_class");
        JAVA_KEYWORDS.put("const", "_const");
        JAVA_KEYWORDS.put("continue", "_continue");
        JAVA_KEYWORDS.put("default", "_default");
        JAVA_KEYWORDS.put("do", "_do");
        JAVA_KEYWORDS.put("double", "_double");
        JAVA_KEYWORDS.put("else", "_else");
        JAVA_KEYWORDS.put("extends", "_extends");
        JAVA_KEYWORDS.put("false", "_false");
        JAVA_KEYWORDS.put("final", "_final");
        JAVA_KEYWORDS.put("finally", "_finally");
        JAVA_KEYWORDS.put("float", "_float");
        JAVA_KEYWORDS.put("for", "_for");
        JAVA_KEYWORDS.put("goto", "_goto");
        JAVA_KEYWORDS.put("if", "_if");
        JAVA_KEYWORDS.put("implements", "_implements");
        JAVA_KEYWORDS.put("import", "_import");
        JAVA_KEYWORDS.put("instanceof", "_instanceof");
        JAVA_KEYWORDS.put("int", "_int");
        JAVA_KEYWORDS.put("interface", "_interface");
        JAVA_KEYWORDS.put("long", "_long");
        JAVA_KEYWORDS.put("native", "_native");
        JAVA_KEYWORDS.put("new", "_new");
        JAVA_KEYWORDS.put("null", "_null");
        JAVA_KEYWORDS.put("package", "_package");
        JAVA_KEYWORDS.put("private", "_private");
        JAVA_KEYWORDS.put("protected", "_protected");
        JAVA_KEYWORDS.put("public", "_public");
        JAVA_KEYWORDS.put("return", "_return");
        JAVA_KEYWORDS.put("short", "_short");
        JAVA_KEYWORDS.put("static", "_static");
        JAVA_KEYWORDS.put("strictfp", "_strictfp");
        JAVA_KEYWORDS.put("super", "_super");
        JAVA_KEYWORDS.put("switch", "_switch");
        JAVA_KEYWORDS.put("synchronized", "_synchronized");
        JAVA_KEYWORDS.put("this", "_this");
        JAVA_KEYWORDS.put("throw", "_throw");
        JAVA_KEYWORDS.put("throws", "_throws");
        JAVA_KEYWORDS.put("transient", "_transient");
        JAVA_KEYWORDS.put("true", "_true");
        JAVA_KEYWORDS.put("try", "_try");
        JAVA_KEYWORDS.put("void", "_void");
        JAVA_KEYWORDS.put("volatile", "_volatile");
        JAVA_KEYWORDS.put("while", "_while");
        JAVA_KEYWORDS.put("enum", "_enum");
        generatedClasses = Collections.synchronizedMap(new WeakHashMap());
    }

    public static class BeanProperty {
        private Class<?> type;
        private String namespace;
        private String name;
        private String signature;
        private String genericSignature;
        private List<Annotation> jaxbAnnotaions = new ArrayList<Annotation>();
        private boolean element;
        private boolean nillable;

        public BeanProperty(String namespace, String name, Class<?> javaClass, Type type, boolean isElement) {
            this.namespace = namespace;
            this.name = name;
            this.signature = CodeGenerationHelper.getJAXWSSignature(javaClass);
            this.type = javaClass;
            this.genericSignature = CodeGenerationHelper.getJAXWSSignature(type);
            this.element = isElement;
            this.nillable = javaClass.isArray();
        }

        public String getName() {
            return this.name;
        }

        public String getSignature() {
            return this.signature;
        }

        public String getGenericSignature() {
            return this.genericSignature;
        }

        public Class<?> getType() {
            return this.type;
        }

        public List<Annotation> getJaxbAnnotaions() {
            return this.jaxbAnnotaions;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public boolean isElement() {
            return this.element;
        }

        public boolean isNillable() {
            return this.nillable;
        }
    }
}

