/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.jaxws;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;
import org.apache.tuscany.sca.databinding.jaxb.XMLAdapterExtensionPoint;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.java.jaxws.FaultBeanGenerator;
import org.apache.tuscany.sca.interfacedef.java.jaxws.GeneratedClassLoader;
import org.apache.tuscany.sca.interfacedef.java.jaxws.WrapperBeanGenerator;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedDataTypeImpl
implements DataType<XMLType> {
    private XMLAdapterExtensionPoint xmlAdapters;
    private Class<?> physical;
    private XMLType logical;
    private Map<Class<?>, Object> metaDataMap;
    private Method method;
    private String wrapperClassName;
    private String wrapperNamespace;
    private String wrapperName;
    private boolean request;
    private GeneratedClassLoader classLoader;
    private Class<? extends Throwable> exceptionClass;

    public GeneratedDataTypeImpl(XMLAdapterExtensionPoint xmlAdapters, Class<? extends Throwable> exceptionClass, GeneratedClassLoader cl) {
        this.exceptionClass = exceptionClass;
        this.classLoader = cl;
        QName name = FaultBeanGenerator.getElementName(exceptionClass);
        this.logical = new XMLType(name, name);
        this.xmlAdapters = xmlAdapters;
    }

    public GeneratedDataTypeImpl(XMLAdapterExtensionPoint xmlAdapters, Method m, String wrapperClassName, String wrapperNamespace, String wrapperName, boolean request, GeneratedClassLoader cl) {
        this.method = m;
        this.wrapperClassName = wrapperClassName;
        this.wrapperNamespace = wrapperNamespace;
        this.wrapperName = wrapperName;
        this.classLoader = cl;
        this.request = request;
        QName name = new QName(wrapperNamespace, wrapperName);
        this.logical = new XMLType(name, name);
        this.xmlAdapters = xmlAdapters;
    }

    public String getDataBinding() {
        return JAXBDataBinding.NAME;
    }

    public Type getGenericType() {
        return this.getPhysical();
    }

    public XMLType getLogical() {
        return this.logical;
    }

    public synchronized Class<?> getPhysical() {
        if (this.physical == null) {
            if (this.method != null) {
                WrapperBeanGenerator generator = new WrapperBeanGenerator();
                generator.setXmlAdapters(this.xmlAdapters);
                this.physical = this.request ? generator.generateRequestWrapper(this.method, this.wrapperClassName, this.wrapperNamespace, this.wrapperName, this.classLoader) : generator.generateResponseWrapper(this.method, this.wrapperClassName, this.wrapperNamespace, this.wrapperName, this.classLoader);
            } else if (this.exceptionClass != null) {
                FaultBeanGenerator faultBeanGenerator = new FaultBeanGenerator();
                faultBeanGenerator.setXmlAdapters(this.xmlAdapters);
                this.physical = faultBeanGenerator.generate(this.exceptionClass, this.classLoader);
            }
        }
        return this.physical;
    }

    public void setDataBinding(String dataBinding) {
    }

    public void setGenericType(Type genericType) {
    }

    public void setLogical(XMLType logical) {
        this.logical = logical;
    }

    public void setPhysical(Class<?> cls) {
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public <T> T getMetaData(Class<T> type) {
        return this.metaDataMap == null ? null : (T)type.cast(this.metaDataMap.get(type));
    }

    public <T> void setMetaData(Class<T> type, T metaData) {
        if (this.metaDataMap == null) {
            this.metaDataMap = new ConcurrentHashMap();
        }
        this.metaDataMap.put(type, metaData);
    }
}

