/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.interfacedef.java.introspect.JavaInterfaceVisitor;

public class JAXRSJavaInterfaceProcessor
implements JavaInterfaceVisitor {
    private static Map<String, Class<?>> mapping = new HashMap();

    private boolean introspectHTTPMethod(JavaOperation operation) {
        Method method = operation.getJavaMethod();
        String methodName = null;
        for (Annotation a : method.getAnnotations()) {
            Class<? extends Annotation> annotationType = a.annotationType();
            if (annotationType == HttpMethod.class) {
                methodName = ((HttpMethod)a).value();
                break;
            }
            HttpMethod m = a.annotationType().getAnnotation(HttpMethod.class);
            if (m == null) continue;
            methodName = m.value();
            break;
        }
        boolean jaxrs = false;
        Class<?> type = mapping.get(methodName);
        if (type != null) {
            jaxrs = true;
            operation.getAttributes().put(type, Boolean.TRUE);
            Map attrs = operation.getInterface().getAttributes();
            ArrayList<JavaOperation> operations = (ArrayList<JavaOperation>)attrs.get(type);
            if (operations == null) {
                operations = new ArrayList<JavaOperation>();
                attrs.put(type, operations);
                operations.add(operation);
            } else {
                operations.add(operation);
            }
        }
        return jaxrs;
    }

    public void visitInterface(JavaInterface contract) throws InvalidInterfaceException {
        boolean hasJAXRSAnnotarions = false;
        for (Operation op : contract.getOperations()) {
            JavaOperation operation = (JavaOperation)op;
            if (!this.introspectHTTPMethod(operation)) continue;
            hasJAXRSAnnotarions = true;
        }
        if (hasJAXRSAnnotarions) {
            contract.setRemotable(true);
        }
    }

    static {
        mapping.put("GET", GET.class);
        mapping.put("POST", POST.class);
        mapping.put("PUT", PUT.class);
        mapping.put("DELETE", DELETE.class);
        mapping.put("HEAD", HEAD.class);
        mapping.put("OPTIONS", OPTIONS.class);
    }
}

