/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.jaxrs;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.tuscany.sca.interfacedef.java.jaxrs.CodeGenerationHelper;
import org.apache.tuscany.sca.interfacedef.java.jaxrs.GeneratedClassLoader;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class RootResourceClassGenerator
implements Opcodes {
    private static final String DELEGATE_FIELD = "delegate";

    public static Class<?> generateRootResourceClass(Class<?> interfaze, String path, String consumes, String produces) throws Exception {
        if (!interfaze.isInterface()) {
            throw new IllegalArgumentException(interfaze + " is not an interface.");
        }
        GeneratedClassLoader classLoader = new GeneratedClassLoader(interfaze.getClassLoader());
        String interfaceName = interfaze.getName();
        int index = interfaze.getName().lastIndexOf(46);
        String className = interfaceName.substring(0, index) + ".Generated" + interfaceName.substring(index + 1) + "Impl";
        byte[] content = RootResourceClassGenerator.generate(interfaze, path, consumes, produces);
        Class<?> cls = classLoader.getGeneratedClass(className, content);
        return cls;
    }

    public static void injectProxy(Class<?> generatedResourceClass, Object proxy) throws Exception {
        Field field = generatedResourceClass.getField(DELEGATE_FIELD);
        field.set(null, proxy);
    }

    public static byte[] generate(Class<?> interfaze, String path, String consumes, String produces) throws Exception {
        String interfaceName = Type.getInternalName(interfaze);
        int index = interfaceName.lastIndexOf(47);
        String className = interfaceName.substring(0, index) + "/Generated" + interfaceName.substring(index + 1) + "Impl";
        ClassWriter cw = new ClassWriter(1);
        RootResourceClassGenerator.declareClass(cw, interfaceName, className);
        RootResourceClassGenerator.annotatePath(cw, path);
        RootResourceClassGenerator.annotateContentTypes(cw, consumes, produces);
        RootResourceClassGenerator.declareField(cw, interfaceName);
        RootResourceClassGenerator.declareConstructor(cw, className);
        for (Method method : interfaze.getMethods()) {
            if (method.getDeclaringClass() == Object.class) continue;
            RootResourceClassGenerator.generateMethod(cw, interfaceName, className, method, consumes, produces);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static void generateMethod(ClassWriter cw, String interfaceName, String className, Method method, String consumes, String produces) {
        String methodDescriptor = Type.getMethodDescriptor((Method)method);
        String signatureString = RootResourceClassGenerator.getSignature(method);
        MethodVisitor mv = cw.visitMethod(1, method.getName(), methodDescriptor, signatureString, RootResourceClassGenerator.getExceptionInternalNames(method));
        mv.visitCode();
        mv.visitFieldInsn(178, className, DELEGATE_FIELD, RootResourceClassGenerator.getSignature(interfaceName));
        Class<?>[] paramTypes = method.getParameterTypes();
        int index = 1;
        for (int i = 0; i < paramTypes.length; ++i) {
            String signature = Type.getDescriptor(paramTypes[i]);
            mv.visitVarInsn(CodeGenerationHelper.getLoadOPCode(signature), index);
            if (paramTypes[i] == Long.TYPE || paramTypes[i] == Double.TYPE) {
                index += 2;
                continue;
            }
            ++index;
        }
        mv.visitMethodInsn(185, interfaceName, method.getName(), methodDescriptor);
        Class<?> returnType = method.getReturnType();
        mv.visitInsn(CodeGenerationHelper.getReturnOPCode(Type.getDescriptor(returnType)));
        int size = paramTypes.length + 1;
        mv.visitMaxs(size, size);
        mv.visitEnd();
    }

    private static String getSignature(Method method) {
        try {
            Field field = method.getClass().getDeclaredField("signature");
            field.setAccessible(true);
            return (String)field.get(method);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static String[] getExceptionInternalNames(Method method) {
        Class<?>[] types = method.getExceptionTypes();
        if (types.length == 0) {
            return null;
        }
        String[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            names[i] = Type.getInternalName(types[i]);
        }
        return names;
    }

    private static String getSignature(String interfaceName) {
        return "L" + interfaceName + ";";
    }

    private static void declareConstructor(ClassWriter cw, String className) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", RootResourceClassGenerator.getSignature(className), null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void declareField(ClassWriter cw, String interfaceName) {
        FieldVisitor fv = cw.visitField(9, DELEGATE_FIELD, RootResourceClassGenerator.getSignature(interfaceName), null, null);
        fv.visitEnd();
    }

    private static void declareClass(ClassWriter cw, String interfaceName, String className) {
        cw.visit(49, 33, className, null, "java/lang/Object", new String[]{interfaceName});
    }

    private static void annotatePath(ClassWriter cw, String path) {
        AnnotationVisitor av = cw.visitAnnotation("Ljavax/ws/rs/Path;", true);
        av.visit("value", (Object)path);
        av.visitEnd();
    }

    private static void annotateContentTypes(ClassWriter cw, String consumes, String produces) {
        AnnotationVisitor av1;
        AnnotationVisitor av = null;
        if (consumes != null) {
            av = cw.visitAnnotation("Ljavax/ws/rs/Consumes;", true);
            av1 = av.visitArray("value");
            for (String s : consumes.split("(,| )")) {
                av1.visit(null, (Object)s.trim());
            }
            av1.visitEnd();
            av.visitEnd();
        }
        if (produces != null) {
            av = cw.visitAnnotation("Ljavax/ws/rs/Produces;", true);
            av1 = av.visitArray("value");
            for (String s : produces.split("(,| )")) {
                av1.visit(null, (Object)s.trim());
            }
            av1.visitEnd();
            av.visitEnd();
        }
    }

    private static void annotateContentTypes(MethodVisitor mv, String consumes, String produces) {
        AnnotationVisitor av1;
        AnnotationVisitor av = null;
        if (consumes != null) {
            av = mv.visitAnnotation("Ljavax/ws/rs/Consumes;", true);
            av1 = av.visitArray("value");
            for (String s : consumes.split("(,| )")) {
                av1.visit(null, (Object)s.trim());
            }
            av1.visitEnd();
            av.visitEnd();
        }
        if (produces != null) {
            av = mv.visitAnnotation("Ljavax/ws/rs/Produces;", true);
            av1 = av.visitArray("value");
            for (String s : produces.split("(,| )")) {
                av1.visit(null, (Object)s.trim());
            }
            av1.visitEnd();
            av.visitEnd();
        }
    }
}

