/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.jaxrs;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;

public class CodeGenerationHelper {
    public static Class<?> getErasure(java.lang.reflect.Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Class<?> componentType = CodeGenerationHelper.getErasure(arrayType.getGenericComponentType());
            return Array.newInstance(componentType, 0).getClass();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return CodeGenerationHelper.getErasure(pType.getRawType());
        }
        if (type instanceof WildcardType) {
            WildcardType wType = (WildcardType)type;
            java.lang.reflect.Type[] types = wType.getUpperBounds();
            if (types.length == 0) {
                return Object.class;
            }
            return CodeGenerationHelper.getErasure(types[0]);
        }
        if (type instanceof TypeVariable) {
            TypeVariable var = (TypeVariable)type;
            java.lang.reflect.Type[] types = var.getBounds();
            if (types.length == 0) {
                return Object.class;
            }
            return CodeGenerationHelper.getErasure(types[0]);
        }
        return null;
    }

    public static String getJAXWSSignature(java.lang.reflect.Type type) {
        Class<?> cls = CodeGenerationHelper.getErasure(type);
        if (Collection.class.isAssignableFrom(cls) && type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            java.lang.reflect.Type p = pType.getActualTypeArguments()[0];
            StringBuffer sb = new StringBuffer();
            sb.append(CodeGenerationHelper.getSignature(cls));
            sb.deleteCharAt(sb.length() - 1);
            sb.append('<').append(CodeGenerationHelper.getSignature(CodeGenerationHelper.getErasure(p))).append(">;");
            return sb.toString();
        }
        if (Map.class.isAssignableFrom(cls) && type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            java.lang.reflect.Type key = pType.getActualTypeArguments()[0];
            java.lang.reflect.Type value = pType.getActualTypeArguments()[1];
            StringBuffer sb = new StringBuffer();
            sb.append(CodeGenerationHelper.getSignature(cls));
            sb.deleteCharAt(sb.length() - 1);
            sb.append('<').append(CodeGenerationHelper.getSignature(CodeGenerationHelper.getErasure(key))).append(CodeGenerationHelper.getSignature(CodeGenerationHelper.getErasure(value))).append(">;");
            return sb.toString();
        }
        return CodeGenerationHelper.getSignature(cls);
    }

    public static String getSignature(java.lang.reflect.Type type) {
        if (!(type instanceof Class)) {
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                StringBuffer sb = new StringBuffer();
                String rawType = CodeGenerationHelper.getSignature(pType.getRawType());
                sb.append(rawType.substring(0, rawType.length() - 1));
                sb.append('<');
                for (java.lang.reflect.Type t : pType.getActualTypeArguments()) {
                    String argType = CodeGenerationHelper.getSignature(t);
                    sb.append(argType);
                }
                sb.append('>');
                sb.append(rawType.substring(rawType.length() - 1));
                return sb.toString();
            }
            if (type instanceof TypeVariable) {
                return "T" + ((TypeVariable)type).getName() + ";";
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type;
                return "[" + CodeGenerationHelper.getSignature(arrayType.getGenericComponentType());
            }
            if (type instanceof WildcardType) {
                WildcardType wType = (WildcardType)type;
                java.lang.reflect.Type[] types = wType.getUpperBounds();
                StringBuffer sb = new StringBuffer();
                if (types.length == 0 || types.length != 1 || types[0] != Object.class) {
                    sb.append('+');
                    for (java.lang.reflect.Type t : types) {
                        sb.append(CodeGenerationHelper.getSignature(t));
                    }
                }
                if ((types = wType.getLowerBounds()).length != 0) {
                    sb.append('-');
                    for (java.lang.reflect.Type t : wType.getLowerBounds()) {
                        sb.append(CodeGenerationHelper.getSignature(t));
                    }
                }
                if (sb.length() == 0) {
                    return "*";
                }
                return sb.toString();
            }
        }
        Class cls = (Class)type;
        return Type.getDescriptor((Class)cls);
    }

    public static <T> List<Class<?>> resovleTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        java.lang.reflect.Type type = childClass;
        while (!CodeGenerationHelper.getErasure(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class<?> rawType = CodeGenerationHelper.getErasure(parameterizedType.getRawType());
            java.lang.reflect.Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<?>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        java.lang.reflect.Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (java.lang.reflect.Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (java.lang.reflect.Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(CodeGenerationHelper.getErasure(baseType));
        }
        return typeArgumentsAsClasses;
    }

    public static int getLoadOPCode(String signature) {
        if ("Z".equals(signature) || "B".equals(signature) || "C".equals(signature) || "S".equals(signature) || "I".equals(signature)) {
            return 21;
        }
        if ("J".equals(signature)) {
            return 22;
        }
        if ("F".equals(signature)) {
            return 23;
        }
        if ("D".equals(signature)) {
            return 24;
        }
        return 25;
    }

    public static int getReturnOPCode(String signature) {
        if ("Z".equals(signature) || "B".equals(signature) || "C".equals(signature) || "S".equals(signature) || "I".equals(signature)) {
            return 172;
        }
        if ("J".equals(signature)) {
            return 173;
        }
        if ("F".equals(signature)) {
            return 174;
        }
        if ("D".equals(signature)) {
            return 175;
        }
        if ("V".equals(signature)) {
            return 177;
        }
        return 176;
    }

    public static String getPackagePrefix(Class<?> cls) {
        String name = cls.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "jaxws.";
        }
        return name.substring(0, index) + ".jaxws.";
    }
}

