/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.widget;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.binding.http.HTTPBinding;
import org.apache.tuscany.sca.binding.http.HTTPBindingFactory;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.widget.Widget;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementation;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementationFactory;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementationIntrospector;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class WidgetImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<WidgetImplementation> {
    private ExtensionPointRegistry registry;
    private AssemblyFactory assemblyFactory;
    private ContributionFactory contributionFactory;
    private HTTPBindingFactory httpBindingFactory;
    private JavaInterfaceFactory javaInterfaceFactory;
    private WidgetImplementationFactory implementationFactory;

    public WidgetImplementationProcessor(ExtensionPointRegistry registry) {
        this.registry = registry;
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = (AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
        this.contributionFactory = (ContributionFactory)modelFactories.getFactory(ContributionFactory.class);
        this.httpBindingFactory = (HTTPBindingFactory)modelFactories.getFactory(HTTPBindingFactory.class);
        this.javaInterfaceFactory = (JavaInterfaceFactory)modelFactories.getFactory(JavaInterfaceFactory.class);
        this.implementationFactory = (WidgetImplementationFactory)modelFactories.getFactory(WidgetImplementationFactory.class);
    }

    public QName getArtifactType() {
        return WidgetImplementation.TYPE;
    }

    public Class<WidgetImplementation> getModelType() {
        return WidgetImplementation.class;
    }

    public WidgetImplementation read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        WidgetImplementation implementation = this.implementationFactory.createWidgetImplementation();
        implementation.setUnresolved(true);
        String location = this.getURIString(reader, "location");
        if (location != null && !location.isEmpty()) {
            implementation.setLocation(location);
        } else {
            this.error(context.getMonitor(), "LocationAttributeMissing", (Object)reader, new Object[0]);
        }
        String widgetUri = this.getURIString(reader, "widgetUri");
        if (widgetUri != null && !widgetUri.isEmpty()) {
            implementation.setWidgetUri(widgetUri);
        } else {
            this.warning(context.getMonitor(), "UocationAttributeMissing", reader, new Object[0]);
        }
        while (reader.hasNext() && (reader.next() != 2 || !WidgetImplementation.TYPE.equals(reader.getName()))) {
        }
        return implementation;
    }

    public void resolve(WidgetImplementation implementation, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (implementation != null) {
            Artifact artifact = this.contributionFactory.createArtifact();
            artifact.setURI(implementation.getLocation());
            Artifact resolved = (Artifact)resolver.resolveModel(Artifact.class, (Object)artifact, context);
            if (resolved.getLocation() == null) {
                URI base;
                URL resource = null;
                URI uri = URI.create(implementation.getLocation());
                Artifact parent = context.getArtifact();
                if (!uri.isAbsolute() && parent != null && parent.getURI() != null && (uri = (base = URI.create("/" + parent.getURI())).resolve(uri)).toString().startsWith("/")) {
                    uri = URI.create(uri.toString().substring(1));
                }
                if (parent != null && parent.getLocation() != null) {
                    try {
                        resource = new URL(new URL(parent.getLocation()), implementation.getLocation());
                        implementation.setLocationURL(resource);
                    }
                    catch (MalformedURLException e) {
                        ContributionResolveException ce = new ContributionResolveException((Throwable)e);
                        this.error(context.getMonitor(), "ContributionResolveException", (Object)resolver, (Exception)ce);
                    }
                }
            } else {
                try {
                    implementation.setLocationURL(new URL(resolved.getLocation()));
                }
                catch (MalformedURLException e) {
                    ContributionResolveException ce = new ContributionResolveException((Throwable)e);
                    this.error(context.getMonitor(), "ContributionResolveException", (Object)resolver, (Exception)ce);
                }
            }
            WidgetImplementationIntrospector widgetIntrospector = new WidgetImplementationIntrospector(this.registry, implementation);
            widgetIntrospector.introspectImplementation();
            implementation.setUnresolved(false);
            if (implementation.getWidgetUri() != null && !implementation.getWidgetUri().isEmpty()) {
                this.addService(implementation);
            }
            if (implementation.isUnresolved()) {
                this.error(context.getMonitor(), "CouldNotResolveLocation", (Object)resolver, implementation.getLocation());
            }
        }
    }

    public void write(WidgetImplementation implementation, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, WidgetImplementation.TYPE.getNamespaceURI(), WidgetImplementation.TYPE.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[0]);
        if (implementation.getLocation() != null && !implementation.getLocation().isEmpty()) {
            writer.writeAttribute("location", implementation.getLocation());
        }
        if (implementation.getWidgetUri() != null && !implementation.getWidgetUri().isEmpty()) {
            writer.writeAttribute("widgetUri", implementation.getWidgetUri());
        }
        this.writeEnd(writer);
    }

    private void addService(WidgetImplementation implementation) {
        JavaInterface javaInterface;
        Service widgetService = null;
        widgetService = this.assemblyFactory.createService();
        widgetService.setName("Widget");
        try {
            javaInterface = this.javaInterfaceFactory.createJavaInterface(Widget.class);
        }
        catch (InvalidInterfaceException e) {
            throw new IllegalArgumentException(e);
        }
        JavaInterfaceContract interfaceContract = this.javaInterfaceFactory.createJavaInterfaceContract();
        interfaceContract.setInterface((Interface)javaInterface);
        widgetService.setInterfaceContract((InterfaceContract)interfaceContract);
        HTTPBinding binding = this.httpBindingFactory.createHTTPBinding();
        binding.setURI(implementation.getWidgetUri());
        widgetService.getBindings().add(binding);
        implementation.getServices().add(widgetService);
    }

    private void warning(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(((Object)((Object)this)).getClass().getName(), "impl-widget-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(((Object)((Object)this)).getClass().getName(), "impl-widget-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(((Object)((Object)this)).getClass().getName(), "impl-widget-validation-messages", Problem.Severity.ERROR, model, message, (Throwable)ex);
            monitor.problem(problem);
        }
    }
}

