/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.widget;

import java.net.URL;
import java.net.URLConnection;
import java.util.Scanner;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementation;

class WidgetImplementationIntrospector {
    private static final String WEB_REFERENCE_ANNOTATION = "//@Reference";
    private static final String WEB_PROPERTY_ANNOTATION = "//@Property";
    private AssemblyFactory assemblyFactory;
    private WidgetImplementation widgetImplementation;

    WidgetImplementationIntrospector(ExtensionPointRegistry registry, WidgetImplementation widgetImplementation) {
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = (AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
        this.widgetImplementation = widgetImplementation;
    }

    public void introspectImplementation() {
        URL htmlWidget = this.widgetImplementation.getLocationURL();
        try {
            URLConnection connection = htmlWidget.openConnection();
            connection.setUseCaches(false);
            Scanner scanner = new Scanner(connection.getInputStream());
            while (scanner.hasNextLine()) {
                Reference reference;
                String line = scanner.nextLine();
                if (line.contains(WEB_PROPERTY_ANNOTATION)) {
                    Property property;
                    if (!scanner.hasNextLine() || (property = this.processPropertyScript(scanner.nextLine())) == null) continue;
                    this.widgetImplementation.getProperties().add(property);
                    continue;
                }
                if (!line.contains(WEB_REFERENCE_ANNOTATION) || !scanner.hasNextLine() || (reference = this.processReferenceScript(scanner.nextLine())) == null) continue;
                this.widgetImplementation.getReferences().add(reference);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Property processPropertyScript(String scriptContent) {
        Property property = null;
        String propertyName = null;
        String[] tokens = scriptContent.split("=");
        propertyName = (tokens = tokens[0].split(" "))[tokens.length - 1];
        if (propertyName != null) {
            property = this.assemblyFactory.createProperty();
            property.setName(propertyName);
        }
        return property;
    }

    private Reference processReferenceScript(String scriptContent) {
        Reference reference = null;
        String referenceName = null;
        String[] tokens = scriptContent.split("=");
        referenceName = (tokens = tokens[1].split("\""))[1];
        if (referenceName != null) {
            reference = this.assemblyFactory.createReference();
            reference.setName(referenceName);
        }
        return reference;
    }
}

