/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring;

import java.util.List;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactoryExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.TransformerExtensionPoint;
import org.apache.tuscany.sca.databinding.impl.MediatorImpl;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.apache.tuscany.sca.implementation.spring.SpringImplementationProvider;
import org.apache.tuscany.sca.policy.util.PolicyHandlerDefinitionsLoader;
import org.apache.tuscany.sca.policy.util.PolicyHandlerTuple;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.ImplementationProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringImplementationProviderFactory
implements ImplementationProviderFactory<SpringImplementation> {
    private ProxyFactory proxyFactory;
    private JavaPropertyValueObjectFactory propertyFactory;
    private List<PolicyHandlerTuple> policyHandlerClassNames = null;

    public SpringImplementationProviderFactory(ExtensionPointRegistry extensionPoints) {
        ProxyFactoryExtensionPoint proxyFactories = (ProxyFactoryExtensionPoint)extensionPoints.getExtensionPoint(ProxyFactoryExtensionPoint.class);
        this.proxyFactory = new ExtensibleProxyFactory(proxyFactories);
        DataBindingExtensionPoint dataBindings = (DataBindingExtensionPoint)extensionPoints.getExtensionPoint(DataBindingExtensionPoint.class);
        TransformerExtensionPoint transformers = (TransformerExtensionPoint)extensionPoints.getExtensionPoint(TransformerExtensionPoint.class);
        MediatorImpl mediator = new MediatorImpl(dataBindings, transformers);
        this.propertyFactory = new JavaPropertyValueObjectFactory((Mediator)mediator);
        this.policyHandlerClassNames = PolicyHandlerDefinitionsLoader.loadPolicyHandlerClassnames();
    }

    public ImplementationProvider createImplementationProvider(RuntimeComponent component, SpringImplementation implementation) {
        return new SpringImplementationProvider(component, implementation, this.proxyFactory, this.propertyFactory, this.policyHandlerClassNames);
    }

    public Class<SpringImplementation> getModelType() {
        return SpringImplementation.class;
    }
}

