/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring;

import java.util.List;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.implementation.java.injection.JavaPropertyValueObjectFactory;
import org.apache.tuscany.sca.implementation.spring.SCAParentApplicationContext;
import org.apache.tuscany.sca.implementation.spring.SpringImplementation;
import org.apache.tuscany.sca.implementation.spring.SpringInvoker;
import org.apache.tuscany.sca.implementation.spring.processor.ComponentNameAnnotationProcessor;
import org.apache.tuscany.sca.implementation.spring.processor.ConstructorAnnotationProcessor;
import org.apache.tuscany.sca.implementation.spring.processor.InitDestroyAnnotationProcessor;
import org.apache.tuscany.sca.implementation.spring.processor.PropertyAnnotationProcessor;
import org.apache.tuscany.sca.implementation.spring.processor.ReferenceAnnotationProcessor;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.policy.util.PolicyHandlerTuple;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringImplementationProvider
implements ImplementationProvider {
    private RuntimeComponent component;
    private AbstractApplicationContext springContext;
    private SpringImplementation implementation;

    public SpringImplementationProvider(RuntimeComponent component, SpringImplementation implementation, ProxyFactory proxyService, JavaPropertyValueObjectFactory propertyValueObjectFactory, List<PolicyHandlerTuple> policyHandlerClassNames) {
        this.implementation = implementation;
        this.component = component;
        this.implementation.setPolicyHandlerClassNames(policyHandlerClassNames);
        SCAParentApplicationContext scaParentContext = new SCAParentApplicationContext(component, implementation, proxyService, propertyValueObjectFactory);
        XmlBeanFactory beanFactory = new XmlBeanFactory(implementation.getResource());
        InitDestroyAnnotationProcessor initDestroyProcessor = new InitDestroyAnnotationProcessor();
        beanFactory.addBeanPostProcessor((BeanPostProcessor)initDestroyProcessor);
        ReferenceAnnotationProcessor referenceProcessor = new ReferenceAnnotationProcessor(component);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)referenceProcessor);
        PropertyAnnotationProcessor propertyProcessor = new PropertyAnnotationProcessor(propertyValueObjectFactory, component);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)propertyProcessor);
        ComponentNameAnnotationProcessor componentNameProcessor = new ComponentNameAnnotationProcessor(component);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)componentNameProcessor);
        ConstructorAnnotationProcessor constructorProcessor = new ConstructorAnnotationProcessor();
        beanFactory.addBeanPostProcessor((BeanPostProcessor)constructorProcessor);
        this.springContext = new GenericApplicationContext((DefaultListableBeanFactory)beanFactory, (ApplicationContext)scaParentContext);
    }

    public Invoker createInvoker(RuntimeComponentService service, Operation operation) {
        return new SpringInvoker(this.component, this.springContext, service, operation);
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public void start() {
        this.springContext.refresh();
        this.springContext.start();
    }

    public void stop() {
        this.springContext.close();
        this.springContext.stop();
    }
}

