/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.spring;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.List;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.impl.ImplementationImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaConstructorImpl;
import org.apache.tuscany.sca.implementation.spring.xml.SpringBeanElement;
import org.apache.tuscany.sca.policy.util.PolicyHandlerTuple;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringImplementation
extends ImplementationImpl
implements Implementation,
Extensible {
    private String location = null;
    private Resource resource = null;
    private ComponentType componentType;
    private Hashtable<String, SpringBeanElement> serviceMap;
    private Hashtable<String, Class> propertyMap;
    private List<PolicyHandlerTuple> policyHandlerClassNames = null;
    private Method initMethod = null;
    private Method destroyMethod = null;
    private JavaConstructorImpl<?> constructorDefinition = null;

    protected SpringImplementation() {
        this.setUnresolved(true);
        this.serviceMap = new Hashtable();
        this.propertyMap = new Hashtable();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public JavaConstructorImpl<?> getConstructor() {
        return this.constructorDefinition;
    }

    public void setConstructor(JavaConstructorImpl<?> definition) {
        this.constructorDefinition = definition;
    }

    public Method getInitMethod() {
        return this.initMethod;
    }

    public void setInitMethod(Method initMethod) {
        this.initMethod = initMethod;
    }

    public Method getDestroyMethod() {
        return this.destroyMethod;
    }

    public void setDestroyMethod(Method destroyMethod) {
        this.destroyMethod = destroyMethod;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public void setComponentType(ComponentType componentType) {
        this.componentType = componentType;
    }

    public List<Service> getServices() {
        return this.componentType.getServices();
    }

    public List<Reference> getReferences() {
        return this.componentType.getReferences();
    }

    public List<Property> getProperties() {
        return this.componentType.getProperties();
    }

    public SpringBeanElement getBeanFromService(Service service) {
        SpringBeanElement theBean = this.serviceMap.get(service.getName());
        return theBean;
    }

    public void setBeanForService(Service service, SpringBeanElement theBean) {
        this.serviceMap.put(service.getName(), theBean);
    }

    public void setPropertyClass(String propertyName, Class propertyClass) {
        if (propertyName == null || propertyClass == null) {
            return;
        }
        this.propertyMap.put(propertyName, propertyClass);
    }

    public Class getPropertyClass(String propertyName) {
        return this.propertyMap.get(propertyName);
    }

    public List<PolicyHandlerTuple> getPolicyHandlerClassNames() {
        return this.policyHandlerClassNames;
    }

    public void setPolicyHandlerClassNames(List<PolicyHandlerTuple> policyHandlerClassNames) {
        this.policyHandlerClassNames = policyHandlerClassNames;
    }
}

