/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.python;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.python.PythonEval;
import org.apache.tuscany.sca.implementation.python.PythonImplementation;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceImpl;

public class PythonImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<PythonImplementation> {
    static QName QN = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "implementation.python");
    final InterfaceContract contract;

    public PythonImplementationProcessor(ExtensionPointRegistry ep) throws InvalidInterfaceException {
        FactoryExtensionPoint fep = (FactoryExtensionPoint)ep.getExtensionPoint(FactoryExtensionPoint.class);
        JavaInterfaceFactory jf = (JavaInterfaceFactory)fep.getFactory(JavaInterfaceFactory.class);
        final JavaInterface eval = jf.createJavaInterface(PythonEval.class);
        this.contract = jf.createJavaInterfaceContract();
        class DynamicInterface
        extends JavaInterfaceImpl {
            DynamicInterface() {
                this.setJavaClass(eval.getJavaClass());
                this.setName(eval.getName());
                this.setRemotable(eval.isRemotable());
                Operation op = (Operation)eval.getOperations().get(0);
                op.setDynamic(true);
                this.getOperations().add(op);
                this.resetDataBinding("JSON");
                this.setUnresolved(false);
            }

            public boolean isDynamic() {
                return true;
            }
        }
        this.contract.setInterface((Interface)new DynamicInterface());
    }

    public QName getArtifactType() {
        return QN;
    }

    public Class<PythonImplementation> getModelType() {
        return PythonImplementation.class;
    }

    public PythonImplementation read(XMLStreamReader r, ProcessorContext ctx) throws ContributionReadException, XMLStreamException {
        String scr = r.getAttributeValue(null, "script");
        while (r.hasNext() && (r.next() != 2 || !QN.equals(r.getName()))) {
        }
        return new PythonImplementation(QN, scr, URI.create(ctx.getContribution().getLocation()).getPath(), this.contract);
    }

    public void resolve(PythonImplementation impl, ModelResolver res, ProcessorContext ctx) throws ContributionResolveException {
    }

    public void write(PythonImplementation impl, XMLStreamWriter w, ProcessorContext ctx) throws ContributionWriteException, XMLStreamException {
        this.writeStart(w, QN.getNamespaceURI(), QN.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[]{new BaseStAXArtifactProcessor.XAttr("script", impl.getScript())});
        this.writeEnd(w);
    }
}

