/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.node.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.implementation.node.NodeImplementation;
import org.apache.tuscany.sca.implementation.node.NodeImplementationFactory;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<NodeImplementation> {
    private static final QName IMPLEMENTATION_NODE = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "implementation.node");
    private AssemblyFactory assemblyFactory;
    private NodeImplementationFactory implementationFactory;

    public NodeImplementationProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.assemblyFactory = (AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
        this.implementationFactory = (NodeImplementationFactory)modelFactories.getFactory(NodeImplementationFactory.class);
    }

    public QName getArtifactType() {
        return IMPLEMENTATION_NODE;
    }

    public Class<NodeImplementation> getModelType() {
        return NodeImplementation.class;
    }

    public NodeImplementation read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        NodeImplementation implementation = this.implementationFactory.createNodeImplementation();
        implementation.setUnresolved(false);
        QName qname = this.getQName(reader, "composite");
        if (qname != null) {
            Composite composite = this.assemblyFactory.createComposite();
            composite.setName(qname);
            String uri = this.getString(reader, "uri");
            composite.setURI(uri);
            composite.setUnresolved(true);
            implementation.setComposite(composite);
        }
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_NODE.equals(reader.getName()))) {
        }
        return implementation;
    }

    public void resolve(NodeImplementation implementation, ModelResolver resolver) throws ContributionResolveException {
    }

    public void write(NodeImplementation implementation, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        String uri;
        QName qname;
        Composite composite = implementation.getComposite();
        if (composite != null) {
            qname = composite.getName();
            uri = composite.getURI();
        } else {
            qname = null;
            uri = null;
        }
        this.writeStart(writer, IMPLEMENTATION_NODE.getNamespaceURI(), IMPLEMENTATION_NODE.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[]{new BaseStAXArtifactProcessor.XAttr("composite", qname), new BaseStAXArtifactProcessor.XAttr("uri", uri)});
        this.writeEnd(writer);
    }
}

