/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.context.ThreadMessageContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.invocation.AsyncFaultWrapper;
import org.apache.tuscany.sca.core.invocation.AsyncResponseHandler;
import org.apache.tuscany.sca.core.invocation.AsyncResponseInvoker;
import org.apache.tuscany.sca.core.invocation.CallbackReferenceObjectFactory;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ResponseDispatch;
import org.oasisopen.sca.ServiceReference;

public class ResponseDispatchImpl<T>
implements ResponseDispatch<T>,
Serializable {
    private static final long serialVersionUID = 300158355992568592L;
    private AtomicBoolean latch = new AtomicBoolean();
    private final Lock lock = new ReentrantLock();
    private final Condition completed = this.lock.newCondition();
    private volatile transient T response = null;
    private volatile transient Throwable fault = null;
    private transient ExtensionPointRegistry registry;
    private MessageFactory msgFactory;
    private volatile ServiceReference<AsyncResponseHandler<?>> callbackRef;
    private AsyncResponseInvoker<?> respInvoker;
    private String messageID;

    public ResponseDispatchImpl() {
    }

    public ResponseDispatchImpl(Message msg) {
        this.respInvoker = (AsyncResponseInvoker)msg.getHeaders().get("ASYNC_RESPONSE_INVOKER");
        if (this.respInvoker == null) {
            this.callbackRef = this.getAsyncCallbackRef(msg);
        }
        this.messageID = (String)msg.getHeaders().get("MESSAGE_ID");
    }

    public static <T> ResponseDispatchImpl<T> newInstance(Class<T> type, Message msg) {
        return new ResponseDispatchImpl<T>(msg);
    }

    public Map<String, Object> getContext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFault(Throwable e) {
        if (this.sendOK()) {
            this.lock.lock();
            try {
                this.fault = e;
                this.completed.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        } else {
            throw new IllegalStateException("sendResponse() or sendFault() has been called previously");
        }
        if (this.respInvoker != null) {
            this.respInvoker.invokeAsyncResponse((Object)e, null);
            return;
        }
        AsyncResponseHandler handler = (AsyncResponseHandler)this.callbackRef.getService();
        this.setResponseHeaders();
        handler.setWrappedFault(new AsyncFaultWrapper(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(T res) {
        if (this.sendOK()) {
            this.lock.lock();
            try {
                this.response = res;
                this.completed.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        } else {
            throw new IllegalStateException("sendResponse() or sendFault() has been called previously");
        }
        if (this.callbackRef != null) {
            AsyncResponseHandler handler = (AsyncResponseHandler)this.callbackRef.getService();
            this.setResponseHeaders();
            handler.setResponse(res);
        }
        if (this.respInvoker != null) {
            this.respInvoker.invokeAsyncResponse(res, null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long timeout, TimeUnit unit) throws Throwable {
        this.lock.lock();
        try {
            if (this.response == null && this.fault == null) {
                this.completed.await(timeout, unit);
            }
            if (this.response != null) {
                T t = this.response;
                return t;
            }
            if (this.fault != null) {
                throw this.fault;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    private boolean sendOK() {
        return this.latch.compareAndSet(false, true);
    }

    private ServiceReference<AsyncResponseHandler<?>> getAsyncCallbackRef(Message msg) {
        RuntimeEndpointReference callbackEPR = (RuntimeEndpointReference)msg.getHeaders().get("ASYNC_CALLBACK");
        if (callbackEPR == null) {
            return null;
        }
        CompositeContext compositeContext = callbackEPR.getCompositeContext();
        this.registry = compositeContext.getExtensionPointRegistry();
        ExtensibleProxyFactory proxyFactory = ExtensibleProxyFactory.getInstance((ExtensionPointRegistry)this.registry);
        this.msgFactory = this.getMessageFactory();
        ArrayList<RuntimeEndpointReference> eprList = new ArrayList<RuntimeEndpointReference>();
        eprList.add(callbackEPR);
        CallbackReferenceObjectFactory factory = new CallbackReferenceObjectFactory(AsyncResponseHandler.class, (ProxyFactory)proxyFactory, eprList);
        return (ServiceReference)factory.getInstance();
    }

    private void setResponseHeaders() {
        Message msgContext = ThreadMessageContext.getMessageContext();
        if (msgContext == null) {
            msgContext = this.msgFactory.createMessage();
        }
        msgContext.getHeaders().put("RELATES_TO", this.messageID);
        ThreadMessageContext.setMessageContext((Message)msgContext);
    }

    private MessageFactory getMessageFactory() {
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)this.registry.getExtensionPoint(FactoryExtensionPoint.class);
        return (MessageFactory)modelFactories.getFactory(MessageFactory.class);
    }
}

