/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactory;
import org.apache.tuscany.sca.implementation.java.JavaConstructorImpl;
import org.apache.tuscany.sca.implementation.java.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.context.InstanceFactory;
import org.apache.tuscany.sca.implementation.java.context.InstanceFactoryProvider;
import org.apache.tuscany.sca.implementation.java.context.ReflectiveInstanceFactory;
import org.apache.tuscany.sca.implementation.java.injection.ArrayMultiplicityObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.FieldInjector;
import org.apache.tuscany.sca.implementation.java.injection.Injector;
import org.apache.tuscany.sca.implementation.java.injection.InvalidAccessorException;
import org.apache.tuscany.sca.implementation.java.injection.ListMultiplicityObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.MethodInjector;
import org.apache.tuscany.sca.implementation.java.introspect.JavaIntrospectionHelper;
import org.apache.tuscany.sca.implementation.java.invocation.EventInvoker;
import org.apache.tuscany.sca.implementation.java.invocation.MethodEventInvoker;

public class JavaInstanceFactoryProvider<T>
implements InstanceFactoryProvider<T> {
    private JavaImplementation definition;
    private ProxyFactory proxyService;
    private final List<JavaElementImpl> injectionSites;
    private final EventInvoker<T> initInvoker;
    private final EventInvoker<T> destroyInvoker;
    private final Map<JavaElementImpl, Object> factories = new HashMap<JavaElementImpl, Object>();
    private final List<JavaElementImpl> callbackInjectionSites;

    public JavaInstanceFactoryProvider(JavaImplementation definition) {
        this.definition = definition;
        this.initInvoker = definition.getInitMethod() == null ? null : new MethodEventInvoker(definition.getInitMethod());
        this.destroyInvoker = definition.getDestroyMethod() == null ? null : new MethodEventInvoker(definition.getDestroyMethod());
        this.injectionSites = new ArrayList<JavaElementImpl>();
        this.callbackInjectionSites = new ArrayList<JavaElementImpl>();
    }

    ProxyFactory getProxyFactory() {
        return this.proxyService;
    }

    void setProxyFactory(ProxyFactory proxyService) {
        this.proxyService = proxyService;
    }

    JavaImplementation getImplementation() {
        return this.definition;
    }

    @Override
    public InstanceFactory<T> createFactory() {
        ObjectFactory<?>[] initArgs = this.getConstructorArgs();
        Injector<T>[] injectors = this.getInjectors(false);
        Injector<T>[] callbackInjectors = this.getInjectors(true);
        return new ReflectiveInstanceFactory<T>(this.definition.getConstructor().getConstructor(), initArgs, injectors, callbackInjectors, this.initInvoker, this.destroyInvoker);
    }

    private ObjectFactory<?>[] getConstructorArgs() {
        JavaConstructorImpl constructor = this.definition.getConstructor();
        ObjectFactory[] initArgs = new ObjectFactory[constructor.getParameters().length];
        for (int i = 0; i < initArgs.length; ++i) {
            ObjectFactory factory = (ObjectFactory)this.factories.get(constructor.getParameters()[i]);
            assert (factory != null);
            initArgs[i] = factory;
        }
        return initArgs;
    }

    private Injector<T>[] getInjectors(boolean callback) {
        List<JavaElementImpl> sites = null;
        sites = callback ? this.callbackInjectionSites : this.injectionSites;
        Injector[] injectors = new Injector[sites.size()];
        int i = 0;
        for (JavaElementImpl element : sites) {
            Object obj = this.factories.get(element);
            if (obj == null) continue;
            if (obj instanceof ObjectFactory) {
                ObjectFactory factory = (ObjectFactory)obj;
                Member member = (Member)((Object)element.getAnchor());
                if (element.getElementType() == ElementType.FIELD) {
                    injectors[i++] = new FieldInjector((Field)member, factory);
                    continue;
                }
                if (element.getElementType() == ElementType.PARAMETER && member instanceof Method) {
                    injectors[i++] = new MethodInjector((Method)member, factory);
                    continue;
                }
                if (!(member instanceof Constructor)) {
                    throw new AssertionError((Object)String.valueOf(element));
                }
                continue;
            }
            injectors[i++] = this.createMultiplicityInjector(element, (List)obj);
        }
        return injectors;
    }

    private Injector<T> createMultiplicityInjector(JavaElementImpl element, List<ObjectFactory<?>> factories) {
        Class interfaceType = JavaIntrospectionHelper.getBaseType((Class)element.getType(), (Type)element.getGenericType());
        if (element.getAnchor() instanceof Field) {
            Field field = (Field)element.getAnchor();
            if (field.getType().isArray()) {
                return new FieldInjector(field, new ArrayMultiplicityObjectFactory(interfaceType, factories));
            }
            return new FieldInjector(field, new ListMultiplicityObjectFactory(factories, field.getType()));
        }
        if (element.getAnchor() instanceof Method) {
            Method method = (Method)element.getAnchor();
            if (method.getParameterTypes()[0].isArray()) {
                return new MethodInjector(method, new ArrayMultiplicityObjectFactory(interfaceType, factories));
            }
            return new MethodInjector(method, new ListMultiplicityObjectFactory(factories, method.getParameterTypes()[0]));
        }
        throw new InvalidAccessorException("Member must be a field or method: " + element.getName());
    }

    @Override
    public Class<T> getImplementationClass() {
        return this.definition.getJavaClass();
    }

    @Override
    public void setObjectFactory(JavaElementImpl element, ObjectFactory<?> objectFactory) {
        this.factories.put(element, objectFactory);
    }

    public void setObjectFactories(JavaElementImpl element, List<ObjectFactory<?>> objectFactory) {
        this.factories.put(element, objectFactory);
    }

    List<JavaElementImpl> getInjectionSites() {
        return this.injectionSites;
    }

    public List<JavaElementImpl> getCallbackInjectionSites() {
        return this.callbackInjectionSites;
    }

    Map<JavaElementImpl, Object> getFactories() {
        return this.factories;
    }
}

