/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.injection;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.common.xml.dom.DOMHelper;
import org.apache.tuscany.sca.context.PropertyValueFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.SimpleTypeMapper;
import org.apache.tuscany.sca.databinding.impl.SimpleTypeMapperImpl;
import org.apache.tuscany.sca.databinding.xml.DOMDataBinding;
import org.apache.tuscany.sca.implementation.java.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.introspect.JavaIntrospectionHelper;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JavaPropertyValueObjectFactory
implements PropertyValueFactory {
    private Mediator mediator = null;
    private SimpleTypeMapper simpleTypeMapper;
    private boolean isSimpleType;

    public JavaPropertyValueObjectFactory(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilityExtensionPoint = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.mediator = (Mediator)utilityExtensionPoint.getUtility(Mediator.class);
        this.simpleTypeMapper = (SimpleTypeMapper)utilityExtensionPoint.getUtility(SimpleTypeMapper.class);
    }

    public JavaPropertyValueObjectFactory(Mediator mediator) {
        this.mediator = mediator;
    }

    public ObjectFactory createValueFactory(Property property, Object propertyValue, JavaElementImpl javaElement) {
        Document doc = (Document)propertyValue;
        List<Node> nodes = JavaPropertyValueObjectFactory.getValues(doc);
        Class javaType = JavaIntrospectionHelper.getBaseType((Class)javaElement.getType(), (Type)javaElement.getGenericType());
        if (property.isMany()) {
            if (javaElement.getType().isArray()) {
                return new ArrayObjectFactoryImpl(property, nodes, javaType);
            }
            return new ListObjectFactoryImpl(property, nodes, javaType);
        }
        Node value = null;
        if (!nodes.isEmpty()) {
            value = nodes.get(0);
        }
        return new ObjectFactoryImpl(property, value, javaType);
    }

    public ObjectFactory createValueFactory(Property property, Object propertyValue, Class<?> javaType) {
        Document doc = (Document)propertyValue;
        List<Node> nodes = JavaPropertyValueObjectFactory.getValues(doc);
        if (property.isMany()) {
            return new ListObjectFactoryImpl(property, nodes, javaType);
        }
        Node value = null;
        if (!nodes.isEmpty()) {
            value = nodes.get(0);
        }
        return new ObjectFactoryImpl(property, value, javaType);
    }

    public <B> B createPropertyValue(ComponentProperty property, Class<B> type) {
        this.validateTypes(property, type);
        ObjectFactory factory = this.createValueFactory((Property)property, property.getValue(), type);
        return (B)factory.getInstance();
    }

    private <B> void validateTypes(ComponentProperty property, Class<B> type) {
        DataType prop1 = property.getProperty().getDataType();
        if (prop1 != null && type.isAssignableFrom(prop1.getPhysical())) {
            return;
        }
        if (this.simpleTypeMapper.getXMLType(type) != null ? this.simpleTypeMapper.getXMLType(type).getQName().equals(property.getXSDType()) : this.isSimpleType((Property)property) && type.isAssignableFrom(this.simpleTypeMapper.getJavaType(property.getXSDType()))) {
            return;
        }
        throw new IllegalArgumentException("Property type " + prop1.getPhysical().getName() + " is not compatible with " + type.getName());
    }

    private boolean isSimpleType(Property property) {
        Document doc;
        Element element;
        if (property.getXSDType() != null) {
            return this.simpleTypeMapper.isSimpleXSDType(property.getXSDType());
        }
        return property instanceof Document && (element = (doc = (Document)property).getDocumentElement()).getChildNodes().getLength() == 1 && element.getChildNodes().item(0).getNodeType() == 3;
    }

    private static List<String> getSimplePropertyValues(String concatenatedValue, Class<?> javaType) {
        ArrayList<String> propValues = new ArrayList<String>();
        StringTokenizer st = null;
        st = javaType.getName().equals("java.lang.String") ? new StringTokenizer(concatenatedValue, "\"") : new StringTokenizer(concatenatedValue);
        String aToken = null;
        while (st.hasMoreTokens()) {
            aToken = st.nextToken();
            if (aToken.trim().length() <= 0) continue;
            propValues.add(aToken);
        }
        return propValues;
    }

    private static List<Node> getValues(Document document) {
        ArrayList<Node> propValues = new ArrayList<Node>();
        if (document == null) {
            return propValues;
        }
        Element rootElement = document.getDocumentElement();
        NodeList nodes = rootElement.getChildNodes();
        for (int count = 0; count < nodes.getLength(); ++count) {
            Node node = nodes.item(count);
            if (node.getNodeType() != 1) continue;
            propValues.add(DOMHelper.promote((Node)node));
        }
        return propValues;
    }

    class ArrayObjectFactoryImpl
    extends ObjectFactoryImplBase {
        private Object result;

        public ArrayObjectFactoryImpl(Property property, List<?> propertyValues, Class<?> javaType) {
            super(property, propertyValues, javaType);
            this.result = null;
        }

        public Object getInstance() throws ObjectCreationException {
            if (this.result != null) {
                return this.result;
            }
            if (JavaPropertyValueObjectFactory.this.isSimpleType) {
                int count = 0;
                Object values = Array.newInstance(this.javaType, ((List)this.propertyValue).size());
                for (String aValue : (List)this.propertyValue) {
                    try {
                        Array.set(values, count++, this.simpleTypeMapper.toJavaObject(this.property.getXSDType(), aValue, null));
                    }
                    catch (NumberFormatException ex) {
                        throw new ObjectCreationException("Failed to create instance for property " + this.property.getName() + " with value " + aValue + " from value list of " + this.propertyValue, (Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new ObjectCreationException("Failed to create instance for property " + this.property.getName() + " with value " + aValue + " from value list of " + this.propertyValue, (Throwable)ex);
                    }
                }
                this.result = values;
            } else {
                Object instances = Array.newInstance(this.javaType, ((List)this.propertyValue).size());
                int count = 0;
                for (Node aValue : (List)this.propertyValue) {
                    Array.set(instances, count++, JavaPropertyValueObjectFactory.this.mediator.mediate((Object)aValue, this.sourceDataType, this.targetDataType, null));
                }
                this.result = instances;
            }
            return this.result;
        }
    }

    class ListObjectFactoryImpl
    extends ObjectFactoryImplBase {
        private List result;

        public ListObjectFactoryImpl(Property property, List<?> propertyValues, Class<?> javaType) {
            super(property, propertyValues, javaType);
            this.result = null;
        }

        public List<?> getInstance() throws ObjectCreationException {
            if (this.result != null) {
                return this.result;
            }
            if (JavaPropertyValueObjectFactory.this.isSimpleType) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (String aValue : (List)this.propertyValue) {
                    try {
                        values.add(this.simpleTypeMapper.toJavaObject(this.property.getXSDType(), aValue, null));
                    }
                    catch (NumberFormatException ex) {
                        throw new ObjectCreationException("Failed to create instance for property " + this.property.getName() + " with value " + aValue + " from value list of " + this.propertyValue, (Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new ObjectCreationException("Failed to create instance for property " + this.property.getName() + " with value " + aValue + " from value list of " + this.propertyValue, (Throwable)ex);
                    }
                }
                this.result = values;
            } else {
                ArrayList<Object> instances = new ArrayList<Object>();
                for (Node aValue : (List)this.propertyValue) {
                    instances.add(JavaPropertyValueObjectFactory.this.mediator.mediate((Object)aValue, this.sourceDataType, this.targetDataType, null));
                }
                this.result = instances;
            }
            return this.result;
        }
    }

    class ObjectFactoryImpl
    extends ObjectFactoryImplBase {
        private Object result;

        public ObjectFactoryImpl(Property property, Object propertyValue, Class<?> javaType) {
            super(property, propertyValue, javaType);
            this.result = null;
        }

        public Object getInstance() throws ObjectCreationException {
            if (this.result != null) {
                return this.result;
            }
            if (JavaPropertyValueObjectFactory.this.isSimpleType) {
                try {
                    this.result = this.simpleTypeMapper.toJavaObject(this.property.getXSDType(), (String)this.propertyValue, null);
                }
                catch (NumberFormatException ex) {
                    throw new ObjectCreationException("Failed to create instance for property " + this.property.getName() + " with value " + this.propertyValue, (Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new ObjectCreationException("Failed to create instance for property " + this.property.getName() + " with value " + this.propertyValue, (Throwable)ex);
                }
            } else {
                this.result = JavaPropertyValueObjectFactory.this.mediator.mediate(this.propertyValue, this.sourceDataType, this.targetDataType, null);
            }
            return this.result;
        }
    }

    abstract class ObjectFactoryImplBase
    implements ObjectFactory {
        protected SimpleTypeMapper simpleTypeMapper = new SimpleTypeMapperImpl();
        protected Property property;
        protected Object propertyValue;
        protected Class<?> javaType;
        protected DataType<XMLType> sourceDataType;
        protected DataType<?> targetDataType;

        public ObjectFactoryImplBase(Property property, Object propertyValue, Class<?> javaType) {
            this.property = property;
            this.propertyValue = propertyValue;
            this.javaType = javaType;
            this.sourceDataType = new DataTypeImpl(DOMDataBinding.NAME, Node.class, (Object)new XMLType(null, this.property.getXSDType()));
            this.targetDataType = property.getDataType();
            if (this.targetDataType == null) {
                TypeInfo typeInfo = null;
                typeInfo = this.property.getXSDType() != null ? (this.simpleTypeMapper.isSimpleXSDType(this.property.getXSDType()) ? new TypeInfo(property.getXSDType(), true, null) : new TypeInfo(property.getXSDType(), false, null)) : new TypeInfo(property.getXSDType(), false, null);
                XMLType xmlType = new XMLType(typeInfo);
                String dataBinding = null;
                if (dataBinding != null) {
                    this.targetDataType = new DataTypeImpl(dataBinding, javaType, (Object)xmlType);
                } else {
                    this.targetDataType = new DataTypeImpl(dataBinding, javaType, (Object)xmlType);
                    JavaPropertyValueObjectFactory.this.mediator.getDataBindings().introspectType(this.targetDataType, null);
                }
            }
        }
    }
}

