/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tuscany.sca.implementation.java.invocation.EventInvocationException;
import org.apache.tuscany.sca.implementation.java.invocation.EventInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodEventInvoker<T>
implements EventInvoker<T> {
    private final Method method;

    public MethodEventInvoker(Method method) {
        assert (method != null);
        this.method = method;
    }

    @Override
    public void invokeEvent(T instance) throws EventInvocationException {
        try {
            this.method.invoke(instance, (Object[])null);
        }
        catch (IllegalArgumentException e) {
            String name = this.method.getName();
            throw new EventInvocationException("Exception thrown by event method [" + name + "]", e.getCause());
        }
        catch (IllegalAccessException e) {
            String name = this.method.getName();
            throw new EventInvocationException("Method is not accessible [" + name + "]");
        }
        catch (InvocationTargetException e) {
            String name = this.method.getName();
            throw new EventInvocationException("Exception thrown by event method [" + name + "]", e.getCause());
        }
    }
}

