/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.injection;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.context.PropertyValueFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.SimpleTypeMapper;
import org.apache.tuscany.sca.databinding.impl.DOMHelper;
import org.apache.tuscany.sca.databinding.impl.SimpleTypeMapperImpl;
import org.apache.tuscany.sca.databinding.xml.DOMDataBinding;
import org.apache.tuscany.sca.implementation.java.impl.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.introspect.impl.JavaIntrospectionHelper;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaPropertyValueObjectFactory
implements PropertyValueFactory {
    private Mediator mediator = null;
    private boolean isSimpleType;

    public JavaPropertyValueObjectFactory(Mediator mediator) {
        this.mediator = mediator;
    }

    public JavaPropertyValueObjectFactory(ExtensionPointRegistry registry) {
        this.mediator = (Mediator)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(Mediator.class);
    }

    public ObjectFactory createValueFactory(Property property, Object propertyValue, JavaElementImpl javaElement) {
        this.isSimpleType = this.isSimpleType(property);
        Document doc = (Document)propertyValue;
        Class javaType = JavaIntrospectionHelper.getBaseType((Class)javaElement.getType(), (Type)javaElement.getGenericType());
        Element rootElement = doc.getDocumentElement();
        if (property.isMany()) {
            if (this.isSimpleType) {
                String value = "";
                if (rootElement.getChildNodes().getLength() > 0) {
                    value = rootElement.getChildNodes().item(0).getTextContent();
                }
                List<String> values = this.getSimplePropertyValues(value, javaType);
                if (javaElement.getType().isArray()) {
                    return new ArrayObjectFactoryImpl(property, values, this.isSimpleType, javaType);
                }
                return new ListObjectFactoryImpl(property, values, this.isSimpleType, javaType);
            }
            if (javaElement.getType().isArray()) {
                return new ArrayObjectFactoryImpl(property, this.getComplexPropertyValues(doc), this.isSimpleType, javaType);
            }
            return new ListObjectFactoryImpl(property, this.getComplexPropertyValues(doc), this.isSimpleType, javaType);
        }
        if (this.isSimpleType) {
            String value = "";
            if (rootElement.getChildNodes().getLength() > 0) {
                value = rootElement.getChildNodes().item(0).getTextContent();
            }
            return new ObjectFactoryImpl(property, value, this.isSimpleType, javaType);
        }
        List<Node> nodes = this.getComplexPropertyValues(doc);
        Node value = null;
        if (!nodes.isEmpty()) {
            value = nodes.get(0);
        }
        return new ObjectFactoryImpl(property, value, this.isSimpleType, javaType);
    }

    public ObjectFactory createValueFactory(Property property, Object propertyValue, Class javaType) {
        this.isSimpleType = this.isSimpleType(property);
        Document doc = (Document)propertyValue;
        Element rootElement = doc.getDocumentElement();
        if (property.isMany()) {
            if (this.isSimpleType) {
                String value = "";
                if (rootElement.getChildNodes().getLength() > 0) {
                    value = rootElement.getChildNodes().item(0).getTextContent();
                }
                List<String> values = this.getSimplePropertyValues(value, javaType);
                return new ListObjectFactoryImpl(property, values, this.isSimpleType, javaType);
            }
            return new ListObjectFactoryImpl(property, this.getComplexPropertyValues(doc), this.isSimpleType, javaType);
        }
        if (this.isSimpleType) {
            String value = "";
            if (rootElement.getChildNodes().getLength() > 0) {
                value = rootElement.getChildNodes().item(0).getTextContent();
            }
            return new ObjectFactoryImpl(property, value, this.isSimpleType, javaType);
        }
        List<Node> nodes = this.getComplexPropertyValues(doc);
        Node value = null;
        if (!nodes.isEmpty()) {
            value = nodes.get(0);
        }
        return new ObjectFactoryImpl(property, value, this.isSimpleType, javaType);
    }

    private boolean isSimpleType(Property property) {
        Document doc;
        Element element;
        if (property.getXSDType() != null) {
            return SimpleTypeMapperImpl.isSimpleXSDType((QName)property.getXSDType());
        }
        return property instanceof Document && (element = (doc = (Document)property).getDocumentElement()).getChildNodes().getLength() == 1 && element.getChildNodes().item(0).getNodeType() == 3;
    }

    private List<String> getSimplePropertyValues(String concatenatedValue, Class javaType) {
        ArrayList<String> propValues = new ArrayList<String>();
        StringTokenizer st = null;
        st = javaType.getName().equals("java.lang.String") ? new StringTokenizer(concatenatedValue, "\"") : new StringTokenizer(concatenatedValue);
        String aToken = null;
        while (st.hasMoreTokens()) {
            aToken = st.nextToken();
            if (aToken.trim().length() <= 0) continue;
            propValues.add(aToken);
        }
        return propValues;
    }

    private List<Node> getComplexPropertyValues(Document document) {
        Element rootElement = document.getDocumentElement();
        ArrayList<Node> propValues = new ArrayList<Node>();
        NodeList nodes = rootElement.getChildNodes();
        for (int count = 0; count < nodes.getLength(); ++count) {
            if (nodes.item(count).getNodeType() != 1) continue;
            propValues.add(DOMHelper.promote((Node)nodes.item(count)));
        }
        return propValues;
    }

    public <B> B createPropertyValue(ComponentProperty property, Class<B> type) {
        ObjectFactory factory = this.createValueFactory((Property)property, property.getValue(), type);
        return (B)factory.getInstance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ArrayObjectFactoryImpl
    extends ObjectFactoryImplBase {
        public ArrayObjectFactoryImpl(Property property, List<?> propertyValues, boolean isSimpleType, Class javaType) {
            super(property, propertyValues, isSimpleType, javaType);
        }

        public Object getInstance() throws ObjectCreationException {
            if (this.isSimpleType) {
                int count = 0;
                Object values = Array.newInstance(this.javaType, ((List)this.propertyValue).size());
                for (String aValue : (List)this.propertyValue) {
                    try {
                        Array.set(values, count++, this.simpleTypeMapper.toJavaObject(this.property.getXSDType(), aValue, null));
                    }
                    catch (NumberFormatException ex) {
                        throw new ObjectCreationException("Failed to create instance for property " + this.property.getName() + " with value " + aValue + " from value list of " + this.propertyValue, (Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new ObjectCreationException("Failed to create instance for property " + this.property.getName() + " with value " + aValue + " from value list of " + this.propertyValue, (Throwable)ex);
                    }
                }
                return values;
            }
            Object instances = Array.newInstance(this.javaType, ((List)this.propertyValue).size());
            int count = 0;
            for (Node aValue : (List)this.propertyValue) {
                Array.set(instances, count++, JavaPropertyValueObjectFactory.this.mediator.mediate((Object)aValue, this.sourceDataType, this.targetDataType, null));
            }
            return instances;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListObjectFactoryImpl
    extends ObjectFactoryImplBase {
        public ListObjectFactoryImpl(Property property, List<?> propertyValues, boolean isSimpleType, Class javaType) {
            super(property, propertyValues, isSimpleType, javaType);
        }

        public List<?> getInstance() throws ObjectCreationException {
            if (this.isSimpleType) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (String aValue : (List)this.propertyValue) {
                    try {
                        values.add(this.simpleTypeMapper.toJavaObject(this.property.getXSDType(), aValue, null));
                    }
                    catch (NumberFormatException ex) {
                        throw new ObjectCreationException("Failed to create instance for property " + this.property.getName() + " with value " + aValue + " from value list of " + this.propertyValue, (Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new ObjectCreationException("Failed to create instance for property " + this.property.getName() + " with value " + aValue + " from value list of " + this.propertyValue, (Throwable)ex);
                    }
                }
                return values;
            }
            ArrayList<Object> instances = new ArrayList<Object>();
            for (Node aValue : (List)this.propertyValue) {
                instances.add(JavaPropertyValueObjectFactory.this.mediator.mediate((Object)aValue, this.sourceDataType, this.targetDataType, null));
            }
            return instances;
        }
    }

    public class ObjectFactoryImpl
    extends ObjectFactoryImplBase {
        public ObjectFactoryImpl(Property property, Object propertyValue, boolean isSimpleType, Class javaType) {
            super(property, propertyValue, isSimpleType, javaType);
        }

        public Object getInstance() throws ObjectCreationException {
            if (this.isSimpleType) {
                try {
                    return this.simpleTypeMapper.toJavaObject(this.property.getXSDType(), (String)this.propertyValue, null);
                }
                catch (NumberFormatException ex) {
                    throw new ObjectCreationException("Failed to create instance for property " + this.property.getName() + " with value " + this.propertyValue, (Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    throw new ObjectCreationException("Failed to create instance for property " + this.property.getName() + " with value " + this.propertyValue, (Throwable)ex);
                }
            }
            return JavaPropertyValueObjectFactory.this.mediator.mediate(this.propertyValue, this.sourceDataType, this.targetDataType, null);
        }
    }

    public abstract class ObjectFactoryImplBase
    implements ObjectFactory {
        protected SimpleTypeMapper simpleTypeMapper = new SimpleTypeMapperImpl();
        protected Property property;
        protected Object propertyValue;
        protected Class javaType;
        protected DataType<XMLType> sourceDataType;
        protected DataType<?> targetDataType;
        boolean isSimpleType;

        public ObjectFactoryImplBase(Property property, Object propertyValue, boolean isSimpleType, Class javaType) {
            this.isSimpleType = isSimpleType;
            this.property = property;
            this.propertyValue = propertyValue;
            this.javaType = javaType;
            this.sourceDataType = new DataTypeImpl(DOMDataBinding.NAME, Node.class, (Object)new XMLType(null, this.property.getXSDType()));
            TypeInfo typeInfo = null;
            typeInfo = this.property.getXSDType() != null ? (SimpleTypeMapperImpl.isSimpleXSDType((QName)this.property.getXSDType()) ? new TypeInfo(property.getXSDType(), true, null) : new TypeInfo(property.getXSDType(), false, null)) : new TypeInfo(property.getXSDType(), false, null);
            XMLType xmlType = new XMLType(typeInfo);
            String dataBinding = null;
            if (dataBinding != null) {
                this.targetDataType = new DataTypeImpl(dataBinding, javaType, (Object)xmlType);
            } else {
                this.targetDataType = new DataTypeImpl(dataBinding, javaType, (Object)xmlType);
                JavaPropertyValueObjectFactory.this.mediator.getDataBindings().introspectType(this.targetDataType, null);
            }
        }
    }
}

