/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.invocation;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.OperationsConfigurator;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.invocation.PolicyHandlingInterceptor;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.apache.tuscany.sca.policy.util.PolicyHandler;
import org.apache.tuscany.sca.policy.util.PolicyHandlerUtils;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.apache.tuscany.sca.runtime.RuntimeWireProcessor;

public class JavaPolicyHandlingRuntimeWireProcessor
implements RuntimeWireProcessor {
    private static final Logger logger = Logger.getLogger(JavaPolicyHandlingRuntimeWireProcessor.class.getName());

    public void process(RuntimeWire wire) {
        JavaImplementation javaImpl;
        RuntimeComponent component = wire.getTarget().getComponent();
        if (component != null && component.getImplementation() instanceof JavaImplementation && (javaImpl = (JavaImplementation)component.getImplementation()) instanceof PolicySetAttachPoint) {
            PolicyHandler policyHandler = null;
            ArrayList<PolicyHandler> implPolicyHandlers = new ArrayList<PolicyHandler>();
            PolicySetAttachPoint policiedImpl = (PolicySetAttachPoint)javaImpl;
            try {
                for (PolicySet policySet : component.getPolicySets()) {
                    policyHandler = PolicyHandlerUtils.findPolicyHandler((PolicySet)policySet, (List)javaImpl.getPolicyHandlerClassNames());
                    if (policyHandler != null) {
                        policyHandler.setUp(new Object[]{javaImpl});
                        implPolicyHandlers.add(policyHandler);
                        continue;
                    }
                    logger.warning("No PolicyHandler registered for PolicySet - " + policySet.getName());
                }
                ArrayList<Object> applicablePolicyHandlers = null;
                for (InvocationChain chain : wire.getInvocationChains()) {
                    applicablePolicyHandlers = new ArrayList<PolicyHandler>();
                    if (javaImpl instanceof OperationsConfigurator) {
                        String operationName = chain.getTargetOperation().getName();
                        OperationsConfigurator opConfigurator = (OperationsConfigurator)component;
                        for (ConfiguredOperation confOp : opConfigurator.getConfiguredOperations()) {
                            if (!confOp.getName().equals(operationName)) continue;
                            for (PolicySet policySet : confOp.getPolicySets()) {
                                policyHandler = PolicyHandlerUtils.findPolicyHandler((PolicySet)policySet, (List)javaImpl.getPolicyHandlerClassNames());
                                if (policyHandler != null) {
                                    policyHandler.setUp(new Object[]{javaImpl});
                                    applicablePolicyHandlers.add(policyHandler);
                                    continue;
                                }
                                logger.warning("No PolicyHandler registered for " + policySet);
                            }
                        }
                        if (applicablePolicyHandlers.isEmpty()) {
                            applicablePolicyHandlers = implPolicyHandlers;
                        }
                    }
                    if (applicablePolicyHandlers.isEmpty()) continue;
                    String phase = wire.getSource().getContract() instanceof ComponentReference ? "reference.policy" : "service.policy";
                    chain.addInterceptor("implementation.policy", (Interceptor)new PolicyHandlingInterceptor(chain.getTargetOperation(), applicablePolicyHandlers));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

