/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.injection;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.tuscany.sca.core.factory.ObjectCreationException;
import org.apache.tuscany.sca.core.factory.ObjectFactory;
import org.apache.tuscany.sca.implementation.java.injection.Injector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInjector<T>
implements Injector<T> {
    private final Field field;
    private final ObjectFactory<?> objectFactory;

    public FieldInjector(Field pField, ObjectFactory<?> objectFactory) {
        this.field = pField;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                FieldInjector.this.field.setAccessible(true);
                return null;
            }
        });
        this.objectFactory = objectFactory;
    }

    @Override
    public void inject(T instance) throws ObjectCreationException {
        try {
            this.field.set(instance, this.objectFactory.getInstance());
        }
        catch (IllegalAccessException e) {
            throw new ObjectCreationException("Field is not accessible [" + this.field + "]", (Throwable)e);
        }
    }
}

