/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.webapp;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.scanner.ContributionScanner;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;

public class WebAppContributionScanner
implements ContributionScanner {
    private ServletContext servletContext;
    private ContributionFactory contributionFactory;

    public WebAppContributionScanner(ExtensionPointRegistry registry) {
        this.servletContext = (ServletContext)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(ServletContext.class);
        this.contributionFactory = (ContributionFactory)((FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class)).getFactory(ContributionFactory.class);
    }

    public String getContributionType() {
        return "application/war";
    }

    public List<Artifact> scan(Contribution contribution) throws ContributionReadException {
        try {
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
            URL location = new URL(contribution.getLocation());
            URL root = this.servletContext.getResource("/");
            URI relative = root.toURI().relativize(location.toURI());
            String path = relative.getPath();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            for (Object file : this.servletContext.getResourcePaths(path)) {
                Artifact artifact = this.contributionFactory.createArtifact();
                String name = (String)file;
                name = name.substring(1);
                artifact.setURI(name);
                URL artifactURL = new URL(location, name);
                artifact.setLocation(artifactURL.toString());
                artifacts.add(artifact);
            }
            return artifacts;
        }
        catch (Exception e) {
            throw new ContributionReadException((Throwable)e);
        }
    }
}

