/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.rmi;

import java.rmi.Remote;
import org.apache.tuscany.sca.host.rmi.RMIHost;
import org.apache.tuscany.sca.host.rmi.RMIHostException;
import org.apache.tuscany.sca.host.rmi.RMIHostExtensionPoint;
import org.apache.tuscany.sca.host.rmi.RMIHostRuntimeException;

public class ExtensibleRMIHost
implements RMIHost {
    private RMIHostExtensionPoint rmiHosts;

    public ExtensibleRMIHost(RMIHostExtensionPoint rmiHosts) {
        this.rmiHosts = rmiHosts;
    }

    @Override
    public String registerService(String uri, Remote serviceObject) throws RMIHostException, RMIHostRuntimeException {
        if (this.rmiHosts.getRMIHosts().isEmpty()) {
            throw new RMIHostException("No RMI host is available");
        }
        return this.getDefaultHost().registerService(uri, serviceObject);
    }

    @Override
    public void unregisterService(String uri) throws RMIHostException, RMIHostRuntimeException {
        if (this.rmiHosts.getRMIHosts().isEmpty()) {
            throw new RMIHostException("No RMI host is available");
        }
        this.getDefaultHost().unregisterService(uri);
    }

    @Override
    public Remote findService(String uri) throws RMIHostException, RMIHostRuntimeException {
        if (this.rmiHosts.getRMIHosts().isEmpty()) {
            throw new RMIHostException("No RMI host available");
        }
        return this.getDefaultHost().findService(uri);
    }

    protected RMIHost getDefaultHost() {
        return this.rmiHosts.getRMIHosts().get(0);
    }
}

