/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.http.extensibility.impl;

import java.io.IOException;
import java.net.ServerSocket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.tuscany.sca.host.http.HttpScheme;
import org.apache.tuscany.sca.host.http.extensibility.HttpPortAllocator;

public class DefaultHttpPortAllocatorImpl
implements HttpPortAllocator {
    @Override
    public int getDefaultPort(HttpScheme scheme) {
        int port = 0;
        if (scheme == null || scheme == HttpScheme.HTTP) {
            try {
                port = Integer.parseInt(DefaultHttpPortAllocatorImpl.getVariable("HTTP_PORT", String.valueOf(8080)));
                if (port == 0) {
                    port = this.findFreePort(8080, 9080);
                }
            }
            catch (NumberFormatException e) {
                port = 8080;
            }
        } else if (scheme == HttpScheme.HTTPS) {
            try {
                port = Integer.parseInt(DefaultHttpPortAllocatorImpl.getVariable("HTTPS_PORT", String.valueOf(8443)));
                if (port == 0) {
                    port = this.findFreePort(8443, 9443);
                }
            }
            catch (NumberFormatException e) {
                port = 8443;
            }
        }
        return port;
    }

    private static String getVariable(final String variableName, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String value = System.getProperty(variableName);
                if (!(value != null && value.length() != 0 || (value = System.getenv(variableName)) != null && value.length() != 0)) {
                    value = defaultValue;
                }
                return value;
            }
        });
    }

    private int findFreePort(final int start, final int end) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer run() {
                for (int p = start; p <= end; ++p) {
                    ServerSocket socket = null;
                    try {
                        socket = new ServerSocket(p);
                        Integer n = p;
                        return n;
                    }
                    catch (IOException e) {
                        continue;
                    }
                    finally {
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                return -1;
            }
        });
    }
}

