/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.http.client;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultBackoffStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;

public class HttpClientFactory
implements LifeCycleListener {
    protected int soTimeout = 30000;
    protected int connectionTimeout = 60000;
    protected boolean staleCheckingEnabled = false;
    protected long timeToLive = 60L;
    protected int maxPerRoute = 256;
    protected int maxTotal = 1024;
    protected boolean sslHostVerificationEnabled = false;
    protected HttpClient httpClient;

    public static HttpClientFactory getInstance(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        return (HttpClientFactory)utilities.getUtility(HttpClientFactory.class);
    }

    public HttpClientFactory() {
    }

    public HttpClientFactory(ExtensionPointRegistry registry, Map<String, String> attributes) {
        if (attributes != null) {
            String val = attributes.get("soTimeout");
            if (val != null) {
                this.soTimeout = Integer.parseInt(val);
            }
            if ((val = attributes.get("connectionTimeout")) != null) {
                this.connectionTimeout = Integer.parseInt(val);
            }
            if ((val = attributes.get("staleCheckingEnabled")) != null) {
                this.staleCheckingEnabled = Boolean.parseBoolean(val);
            }
            if ((val = attributes.get("timeToLive")) != null) {
                this.timeToLive = Long.parseLong(val);
            }
            if ((val = attributes.get("sslHostVerificationEnabled")) != null) {
                this.sslHostVerificationEnabled = Boolean.parseBoolean(val);
            }
            if ((val = attributes.get("maxTotal")) != null) {
                this.maxTotal = Integer.parseInt(val);
            }
            if ((val = attributes.get("maxPerRoute")) != null) {
                this.maxPerRoute = Integer.parseInt(val);
            }
        }
    }

    public HttpClient createHttpClient() {
        BasicHttpParams defaultParameters = new BasicHttpParams();
        HttpProtocolParams.setContentCharset((HttpParams)defaultParameters, (String)"UTF-8");
        HttpConnectionParams.setConnectionTimeout((HttpParams)defaultParameters, (int)this.connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)defaultParameters, (int)this.soTimeout);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)defaultParameters, (boolean)this.staleCheckingEnabled);
        SchemeRegistry supportedSchemes = null;
        try {
            supportedSchemes = SchemeRegistryFactory.createSystemDefault();
        }
        catch (SSLInitializationException e) {
            supportedSchemes = SchemeRegistryFactory.createDefault();
        }
        if (!this.sslHostVerificationEnabled) {
            SSLSocketFactory socketFactory = (SSLSocketFactory)supportedSchemes.getScheme("https").getSchemeSocketFactory();
            socketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(supportedSchemes, this.timeToLive, TimeUnit.SECONDS);
        connectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
        connectionManager.setMaxTotal(this.maxTotal);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)defaultParameters);
        client.setConnectionBackoffStrategy((ConnectionBackoffStrategy)new DefaultBackoffStrategy());
        if (this.timeToLive <= 0L) {
            client.setReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        }
        return client;
    }

    public void start() {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
    }

    public void stop() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
            this.httpClient = null;
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

