/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.embedded.impl;

import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.core.assembly.ActivationException;
import org.apache.tuscany.sca.core.assembly.CompositeActivator;
import org.apache.tuscany.sca.host.embedded.SCADomain;
import org.apache.tuscany.sca.host.embedded.impl.DefaultSCADomainComponentManager;
import org.apache.tuscany.sca.host.embedded.management.ComponentManager;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.node.SCAClient;
import org.apache.tuscany.sca.node.SCAContribution;
import org.apache.tuscany.sca.node.SCANode;
import org.apache.tuscany.sca.node.SCANodeFactory;
import org.apache.tuscany.sca.node.impl.NodeImpl;
import org.apache.tuscany.sca.node.impl.RuntimeBootStrapper;
import org.osoa.sca.CallableReference;
import org.osoa.sca.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSCADomain
extends SCADomain {
    private String uri;
    private String[] composites;
    private Map<String, Component> components;
    private ComponentManager componentManager;
    private ClassLoader applicationClassLoader;
    private String domainURI;
    private List<String> contributionURLs;
    private CompositeActivator compositeActivator;
    private SCANode node;
    private SCAClient client;

    public DefaultSCADomain(ClassLoader runtimeClassLoader, ClassLoader applicationClassLoader, String domainURI, String contributionLocation, String ... composites) {
        this.uri = domainURI;
        this.composites = composites;
        this.applicationClassLoader = applicationClassLoader;
        this.domainURI = domainURI;
        this.contributionURLs = new ArrayList<String>();
        if (contributionLocation != null && !"/".equals(contributionLocation)) {
            this.contributionURLs.add(contributionLocation);
        }
        this.composites = composites;
        this.init();
        this.componentManager = new DefaultSCADomainComponentManager(this);
    }

    private String createDeploymentComposite(ClassLoader classLoader, String[] composites) {
        try {
            StringBuffer xml = new StringBuffer("<sca:composite xmlns:sca=\"http://www.osoa.org/xmlns/sca/1.0\"").append(" targetNamespace=\"http://tuscany.apache.org/xmlns/sca/1.0\" name=\"aggregated\">\n");
            XMLInputFactory factory = XMLInputFactory.newInstance();
            for (int i = 0; i < composites.length; ++i) {
                URL url = classLoader.getResource(composites[i]);
                if (url == null) continue;
                String location = NodeImpl.getContributionURL((URL)url, (String)composites[i]).toString();
                if (!this.contributionURLs.contains(location)) {
                    this.contributionURLs.add(location);
                }
                URLConnection connection = url.openConnection();
                connection.setUseCaches(false);
                XMLStreamReader reader = factory.createXMLStreamReader(connection.getInputStream());
                reader.nextTag();
                assert (Constants.COMPOSITE_QNAME.equals(reader.getName()));
                String ns = reader.getAttributeValue(null, "targetNamespace");
                if (ns == null) {
                    ns = "";
                }
                String name = reader.getAttributeValue(null, "name");
                reader.close();
                if ("".equals(ns)) {
                    xml.append("<sca:include name=\"").append(name).append("\"/>\n");
                    continue;
                }
                xml.append("<sca:include xmlns:ns").append(i).append("=\"").append(ns).append("\"");
                xml.append(" name=\"").append("ns").append(i).append(":").append(name).append("\"/>\n");
            }
            xml.append("</sca:composite>");
            return xml.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void init() {
        SCANodeFactory factory = SCANodeFactory.newInstance();
        ArrayList<SCAContribution> contributions = new ArrayList<SCAContribution>();
        if (this.composites != null && this.composites.length > 1) {
            String content = this.createDeploymentComposite(this.applicationClassLoader, this.composites);
            for (String location : this.contributionURLs) {
                contributions.add(new SCAContribution(location, location));
            }
            this.node = factory.createSCANode("http://tuscany.apache.org/xmlns/sca/1.0/aggregated", content, contributions.toArray(new SCAContribution[contributions.size()]));
        } else {
            for (String location : this.contributionURLs) {
                contributions.add(new SCAContribution(location, location));
            }
            String composite = this.composites != null && this.composites.length >= 1 ? this.composites[0] : null;
            this.node = !contributions.isEmpty() ? factory.createSCANode(composite, contributions.toArray(new SCAContribution[contributions.size()])) : factory.createSCANodeFromClassLoader(composite, this.applicationClassLoader);
        }
        this.client = (SCAClient)this.node;
        this.compositeActivator = ((NodeImpl)this.node).getCompositeActivator();
        this.components = new HashMap<String, Component>();
        this.setDefaultPort();
        this.node.start();
        this.getComponents(this.compositeActivator.getDomainComposite());
    }

    private void setDefaultPort() {
        RuntimeBootStrapper rt;
        ServletHostExtensionPoint sh;
        URI uri = URI.create(this.domainURI);
        if (uri.getPort() > -1 && (sh = (ServletHostExtensionPoint)(rt = ((NodeImpl)this.node).getRuntime()).getExtensionPointRegistry().getExtensionPoint(ServletHostExtensionPoint.class)) != null && sh.getServletHosts() != null && !sh.getServletHosts().isEmpty()) {
            ((ServletHost)sh.getServletHosts().get(0)).setDefaultPort(uri.getPort());
        }
    }

    private void getComponents(Composite composite) {
        for (Component c : composite.getComponents()) {
            this.components.put(c.getName(), c);
        }
        for (Composite cp : composite.getIncludes()) {
            this.getComponents(cp);
        }
    }

    @Override
    public void close() {
        super.close();
        this.node.stop();
    }

    @Override
    public <B, R extends CallableReference<B>> R cast(B target) throws IllegalArgumentException {
        return (R)this.client.cast(target);
    }

    @Override
    public <B> B getService(Class<B> businessInterface, String serviceName) {
        return (B)this.client.getService(businessInterface, serviceName);
    }

    @Override
    public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, String name) {
        return this.client.getServiceReference(businessInterface, name);
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public Set<String> getComponentNames() {
        return this.components.keySet();
    }

    public Component getComponent(String componentName) {
        return this.components.get(componentName);
    }

    public void startComponent(String componentName) throws ActivationException {
        Component component = this.getComponent(componentName);
        if (component == null) {
            throw new IllegalArgumentException("no component: " + componentName);
        }
        this.compositeActivator.start(component);
    }

    public void stopComponent(String componentName) throws ActivationException {
        Component component = this.getComponent(componentName);
        if (component == null) {
            throw new IllegalArgumentException("no component: " + componentName);
        }
        this.compositeActivator.stop(component);
    }
}

