/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.embedded.impl;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.core.assembly.ActivationException;
import org.apache.tuscany.sca.core.assembly.RuntimeComponentImpl;
import org.apache.tuscany.sca.host.embedded.impl.DefaultSCADomain;
import org.apache.tuscany.sca.host.embedded.management.ComponentListener;
import org.apache.tuscany.sca.host.embedded.management.ComponentManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultSCADomainComponentManager
implements ComponentManager {
    protected DefaultSCADomain scaDomain;
    protected List<ComponentListener> listeners = new CopyOnWriteArrayList<ComponentListener>();

    public DefaultSCADomainComponentManager(DefaultSCADomain scaDomain) {
        this.scaDomain = scaDomain;
    }

    @Override
    public void addComponentListener(ComponentListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeComponentListener(ComponentListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Set<String> getComponentNames() {
        return this.scaDomain.getComponentNames();
    }

    @Override
    public Component getComponent(String componentName) {
        return this.scaDomain.getComponent(componentName);
    }

    @Override
    public void startComponent(String componentName) throws ActivationException {
        this.scaDomain.startComponent(componentName);
    }

    @Override
    public void stopComponent(String componentName) throws ActivationException {
        this.scaDomain.stopComponent(componentName);
    }

    public void notifyComponentStarted(String componentName) {
        for (ComponentListener listener : this.listeners) {
            try {
                listener.componentStarted(componentName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void notifyComponentStopped(String componentName) {
        for (ComponentListener listener : this.listeners) {
            try {
                listener.componentStopped(componentName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isComponentStarted(String componentName) {
        RuntimeComponentImpl runtimeComponent = (RuntimeComponentImpl)this.getComponent(componentName);
        return runtimeComponent.isStarted();
    }
}

