/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extensibility;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDiscovery {
    private static final Logger logger = Logger.getLogger(ServiceDiscovery.class.getName());
    private static ServiceDiscovery instance;
    private HashSet<ClassLoader> registeredClassLoaders;

    public static ServiceDiscovery getInstance() {
        if (instance == null) {
            instance = new ServiceDiscovery();
            ServiceDiscovery.instance.registeredClassLoaders = new HashSet();
            ServiceDiscovery.instance.registeredClassLoaders.add(ServiceDiscovery.class.getClassLoader());
        }
        return instance;
    }

    public synchronized void registerClassLoader(ClassLoader classLoader) {
        this.registeredClassLoaders.add(classLoader);
    }

    public synchronized void unregisterClassLoader(ClassLoader classLoader) {
        this.registeredClassLoaders.remove(classLoader);
    }

    public synchronized Set<ServiceDeclaration> getServiceDeclarations(String name) throws IOException {
        HashSet<ServiceDeclaration> classSet = new HashSet<ServiceDeclaration>();
        for (ClassLoader classLoader : this.registeredClassLoaders) {
            this.getServiceClasses(classLoader, name, classSet, true);
        }
        return classSet;
    }

    public Set<ServiceDeclaration> getServiceDeclarations(Class<?> serviceInterface) throws IOException {
        return this.getServiceDeclarations(serviceInterface.getName());
    }

    public synchronized Class<?> loadFirstServiceClass(Class<?> serviceInterface) throws IOException, ClassNotFoundException {
        HashSet<ServiceDeclaration> classSet = new HashSet<ServiceDeclaration>();
        for (ClassLoader classLoader : this.registeredClassLoaders) {
            this.getServiceClasses(classLoader, serviceInterface.getName(), classSet, false);
            if (classSet.size() <= 0) continue;
            break;
        }
        if (classSet.size() > 0) {
            return ((ServiceDeclaration)classSet.iterator().next()).loadClass();
        }
        return null;
    }

    public synchronized Hashtable<ClassLoader, Set<URL>> getServiceResources(final String name) throws IOException {
        Hashtable<ClassLoader, Set<URL>> resourceTable = new Hashtable<ClassLoader, Set<URL>>();
        HashSet allURLs = new HashSet();
        for (final ClassLoader classLoader : this.registeredClassLoaders) {
            ArrayList<URL> urlList;
            HashSet<URL> urls = new HashSet<URL>();
            resourceTable.put(classLoader, urls);
            boolean debug = logger.isLoggable(Level.FINE);
            if (debug) {
                logger.fine("Discovering service resources using class loader " + classLoader);
            }
            try {
                urlList = AccessController.doPrivileged(new PrivilegedExceptionAction<ArrayList<URL>>(){

                    @Override
                    public ArrayList<URL> run() throws IOException {
                        return Collections.list(classLoader.getResources("META-INF/services/" + name));
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
            for (URL url : urlList) {
                if (allURLs.contains(url)) continue;
                urls.add(url);
            }
            allURLs.addAll(urls);
        }
        return resourceTable;
    }

    private Map<String, String> parseServiceDeclaration(String declaration) {
        String value;
        String key;
        HashMap<String, String> attributes = new HashMap<String, String>();
        int index = declaration.indexOf(59);
        if (index != -1) {
            attributes.put("class", declaration.substring(0, index).trim());
            declaration = declaration.substring(index);
        } else {
            int j = declaration.indexOf(61);
            if (j == -1) {
                attributes.put("class", declaration.trim());
                return attributes;
            }
            declaration = ";" + declaration;
        }
        StringTokenizer tokens = new StringTokenizer(declaration);
        while (tokens.hasMoreTokens() && (key = tokens.nextToken("=").substring(1).trim()) != null && (value = tokens.nextToken(",").substring(1).trim()) != null) {
            attributes.put(key, value);
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getServiceClasses(final ClassLoader classLoader, final String name, Set<ServiceDeclaration> classSet, boolean findAllClasses) throws IOException {
        ArrayList<URL> urlList;
        boolean debug = logger.isLoggable(Level.FINE);
        if (debug) {
            logger.fine("Discovering service providers using class loader " + classLoader);
        }
        try {
            urlList = AccessController.doPrivileged(new PrivilegedExceptionAction<ArrayList<URL>>(){

                @Override
                public ArrayList<URL> run() throws IOException {
                    return Collections.list(classLoader.getResources("META-INF/services/" + name));
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        for (final URL url : urlList) {
            InputStream is;
            if (debug) {
                logger.fine("Reading service provider file: " + url.toExternalForm());
            }
            try {
                is = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        URLConnection connection = url.openConnection();
                        connection.setDefaultUseCaches(false);
                        connection.setUseCaches(false);
                        return url.openStream();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(is));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || "".equals(line)) continue;
                    String reg = line.trim();
                    if (debug) {
                        logger.fine("Registering service provider: " + reg);
                    }
                    Map<String, String> attributes = this.parseServiceDeclaration(reg);
                    String className = attributes.get("class");
                    ServiceDeclaration serviceClass = new ServiceDeclaration(className, classLoader, attributes);
                    classSet.add(serviceClass);
                    if (!findAllClasses) break;
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            if (findAllClasses || classSet.size() <= 0) continue;
            break;
        }
    }
}

