/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extensibility;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDeclaration {
    private WeakReference<ClassLoader> classLoader;
    private String className;
    private Map<String, String> attributes;

    public ServiceDeclaration(String className, ClassLoader classLoader, Map<String, String> attributes) {
        this.className = className;
        this.classLoader = new WeakReference<ClassLoader>(classLoader);
        this.attributes = attributes;
    }

    public Class<?> loadClass() throws ClassNotFoundException {
        return Class.forName(this.className, true, (ClassLoader)this.classLoader.get());
    }

    public Class<?> loadClass(String anotherClassName) throws ClassNotFoundException {
        return Class.forName(anotherClassName, true, (ClassLoader)this.classLoader.get());
    }

    public URL getResource() {
        return ((ClassLoader)this.classLoader.get()).getResource(this.className);
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoader.get();
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ServiceDeclaration)) {
            return false;
        }
        ServiceDeclaration s = (ServiceDeclaration)o;
        if (!this.className.equals(s.className)) {
            return false;
        }
        if (!this.classLoader.equals(s.classLoader)) {
            return false;
        }
        if (this.attributes == null) {
            return s.attributes == null;
        }
        return ((Object)this.attributes).equals(s.attributes);
    }
}

