/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.impl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.tuscany.sca.TuscanyRuntime;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.deployment.Deployer;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.ValidationException;

public class DependencyUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getDependencies(String contributionURI, Map<String, ZipInputStream> possibles) throws ValidationException, IOException, ContributionReadException, XMLStreamException {
        Deployer deployer = TuscanyRuntime.newInstance().getDeployer();
        HashMap<String, ContributionMetadata> contributionMetaDatas = new HashMap<String, ContributionMetadata>();
        for (String curi : possibles.keySet()) {
            ZipEntry entry;
            ZipInputStream zis = possibles.get(curi);
            while ((entry = zis.getNextEntry()) != null) {
                int size;
                if (!"META-INF/sca-contribution.xml".equals(entry.getName())) continue;
                byte[] buffer = new byte[2048];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BufferedOutputStream bos = new BufferedOutputStream(baos, buffer.length);
                while ((size = zis.read(buffer, 0, buffer.length)) != -1) {
                    bos.write(buffer, 0, size);
                }
                bos.close();
                contributionMetaDatas.put(curi, (ContributionMetadata)deployer.loadXMLDocument((Reader)new StringReader(baos.toString())));
            }
            zis.close();
        }
        Monitor monitor = deployer.createMonitor();
        try {
            List list = deployer.getDependencies(contributionMetaDatas, contributionURI, monitor);
            return list;
        }
        finally {
            monitor.analyzeProblems();
        }
    }
}

