/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.definitions.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.definitions.impl.SCADefinitionsImpl;
import org.apache.tuscany.sca.definitions.util.SCADefinitionsUtil;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCADefinitionsDocumentProcessor
implements URLArtifactProcessor<SCADefinitions> {
    private StAXArtifactProcessor<Object> extensionProcessor;
    private XMLInputFactory inputFactory;
    private static final String TUSCANY_NS = "http://tuscany.apache.org/xmlns/sca/1.0";
    private static final String DEFINITIONS = "definitions";
    private static final QName DEFINITIONS_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "definitions");
    private Monitor monitor;

    public SCADefinitionsDocumentProcessor(StAXArtifactProcessor<Object> staxProcessor, XMLInputFactory inputFactory, Monitor monitor) {
        this.extensionProcessor = staxProcessor;
        this.inputFactory = inputFactory;
        this.monitor = monitor;
    }

    public SCADefinitionsDocumentProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> staxProcessor, Monitor monitor) {
        this.extensionProcessor = staxProcessor;
        this.inputFactory = (XMLInputFactory)modelFactories.getFactory(XMLInputFactory.class);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "definitions-xml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "definitions-xml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem((Problem)problem);
        }
    }

    public SCADefinitions read(URL contributionURL, URI uri, final URL url) throws ContributionReadException {
        ContributionReadException ce;
        SCADefinitionsImpl sCADefinitionsImpl;
        InputStream urlStream = null;
        try {
            try {
                urlStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        URLConnection connection = url.openConnection();
                        connection.setUseCaches(false);
                        return connection.getInputStream();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                this.error("PrivilegedActionException", (Object)url, (IOException)e.getException());
                throw (IOException)e.getException();
            }
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(url.toString(), urlStream);
            SCADefinitionsImpl definitions = new SCADefinitionsImpl();
            QName name = null;
            while (reader.hasNext()) {
                int event = reader.next();
                if (event != 1 && event != 2) continue;
                name = reader.getName();
                if (name.equals(DEFINITIONS_QNAME)) {
                    if (event != 2) continue;
                    sCADefinitionsImpl = definitions;
                    return sCADefinitionsImpl;
                }
                SCADefinitions aDefn = (SCADefinitions)this.extensionProcessor.read(reader);
                SCADefinitionsUtil.aggregateSCADefinitions((SCADefinitions)aDefn, (SCADefinitions)definitions);
            }
            sCADefinitionsImpl = definitions;
        }
        catch (XMLStreamException e) {
            ce = new ContributionReadException((Throwable)e);
            this.error("ContributionReadException", (Object)this.inputFactory, (Exception)ce);
            throw ce;
        }
        catch (IOException e) {
            ce = new ContributionReadException((Throwable)e);
            this.error("ContributionReadException", (Object)this.inputFactory, (Exception)ce);
            throw ce;
        }
        finally {
            try {
                if (urlStream != null) {
                    urlStream.close();
                    urlStream = null;
                }
            }
            catch (IOException ioe) {}
        }
        return sCADefinitionsImpl;
    }

    public void resolve(SCADefinitions scaDefinitions, ModelResolver resolver) throws ContributionResolveException {
        SCADefinitionsUtil.stripDuplicates((SCADefinitions)scaDefinitions);
        this.extensionProcessor.resolve((Object)scaDefinitions, resolver);
    }

    public String getArtifactType() {
        return "definitions.xml";
    }

    public Class<SCADefinitions> getModelType() {
        return SCADefinitions.class;
    }
}

