/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.definitions.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.definitions.impl.SCADefinitionsImpl;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.QualifiedIntent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCADefinitionsProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<SCADefinitions> {
    private StAXArtifactProcessor<Object> extensionProcessor;
    private Monitor monitor;
    public static final String BINDING = "binding";
    public static final String IMPLEMENTATION = "implementation";
    public static final String SCA10_NS = "http://www.osoa.org/xmlns/sca/1.0";
    public static final String SCA_DEFINITIONS = "definitions";
    public static final QName SCA_DEFINITIONS_QNAME = new QName("http://www.osoa.org/xmlns/sca/1.0", "definitions");
    public static final String TARGET_NAMESPACE = "targetNamespace";
    public static final String NAME = "name";

    public SCADefinitionsProcessor(StAXArtifactProcessor<Object> extensionProcessor, ModelResolver modelResolver, Monitor monitor) {
        this.extensionProcessor = extensionProcessor;
        this.monitor = monitor;
    }

    public SCADefinitionsProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor<Object> extensionProcessor, Monitor monitor) {
        this.extensionProcessor = extensionProcessor;
        this.monitor = monitor;
    }

    public SCADefinitions read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        QName name = null;
        SCADefinitionsImpl definitions = null;
        String targetNamespace = null;
        while (reader.hasNext()) {
            int event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (SCA_DEFINITIONS_QNAME.equals(name)) {
                        definitions = new SCADefinitionsImpl();
                        targetNamespace = reader.getAttributeValue(null, TARGET_NAMESPACE);
                        definitions.setTargetNamespace(targetNamespace);
                        break;
                    }
                    Object extension = this.extensionProcessor.read(reader);
                    if (extension == null) break;
                    if (extension instanceof Intent) {
                        Intent intent = (Intent)extension;
                        intent.setName(new QName(targetNamespace, intent.getName().getLocalPart()));
                        if (intent instanceof QualifiedIntent) {
                            QualifiedIntent qualifiedIntent = (QualifiedIntent)intent;
                            qualifiedIntent.getQualifiableIntent().setName(new QName(targetNamespace, qualifiedIntent.getQualifiableIntent().getName().getLocalPart()));
                        }
                        definitions.getPolicyIntents().add(intent);
                        break;
                    }
                    if (extension instanceof PolicySet) {
                        PolicySet policySet = (PolicySet)extension;
                        policySet.setName(new QName(targetNamespace, policySet.getName().getLocalPart()));
                        definitions.getPolicySets().add(policySet);
                        break;
                    }
                    if (!(extension instanceof IntentAttachPointType)) break;
                    IntentAttachPointType type = (IntentAttachPointType)extension;
                    if (type.getName().getLocalPart().startsWith(BINDING)) {
                        definitions.getBindingTypes().add((IntentAttachPointType)extension);
                        break;
                    }
                    if (!type.getName().getLocalPart().startsWith(IMPLEMENTATION)) break;
                    definitions.getImplementationTypes().add((IntentAttachPointType)extension);
                    break;
                }
                case 4: {
                    break;
                }
                case 2: {
                    name = reader.getName();
                    if (!SCA_DEFINITIONS_QNAME.equals(name)) break;
                    return definitions;
                }
            }
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return definitions;
    }

    public void write(SCADefinitions definitions, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.writeStartDocument(writer, SCA10_NS, SCA_DEFINITIONS, new BaseStAXArtifactProcessor.XAttr[]{new BaseStAXArtifactProcessor.XAttr(TARGET_NAMESPACE, definitions.getTargetNamespace())});
        for (Intent policyIntent : definitions.getPolicyIntents()) {
            this.extensionProcessor.write((Object)policyIntent, writer);
        }
        for (PolicySet policySet : definitions.getPolicySets()) {
            this.extensionProcessor.write((Object)policySet, writer);
        }
        for (IntentAttachPointType bindingType : definitions.getBindingTypes()) {
            this.extensionProcessor.write((Object)bindingType, writer);
        }
        for (IntentAttachPointType implType : definitions.getImplementationTypes()) {
            this.extensionProcessor.write((Object)implType, writer);
        }
        this.writeEndDocument(writer);
    }

    public void resolve(SCADefinitions scaDefns, ModelResolver resolver) throws ContributionResolveException {
        int count;
        for (Intent policyIntent : scaDefns.getPolicyIntents()) {
            resolver.addModel((Object)policyIntent);
        }
        for (PolicySet policySet : scaDefns.getPolicySets()) {
            resolver.addModel((Object)policySet);
        }
        for (IntentAttachPointType bindingType : scaDefns.getBindingTypes()) {
            resolver.addModel((Object)bindingType);
        }
        for (IntentAttachPointType implType : scaDefns.getImplementationTypes()) {
            resolver.addModel((Object)implType);
        }
        int size = scaDefns.getPolicyIntents().size();
        for (count = 0; count < size; ++count) {
            Intent intent = (Intent)scaDefns.getPolicyIntents().get(count);
            this.extensionProcessor.resolve((Object)intent, resolver);
        }
        size = scaDefns.getPolicySets().size();
        for (count = 0; count < size; ++count) {
            PolicySet policySet = (PolicySet)scaDefns.getPolicySets().get(count);
            this.extensionProcessor.resolve((Object)policySet, resolver);
        }
        size = scaDefns.getBindingTypes().size();
        for (count = 0; count < size; ++count) {
            IntentAttachPointType bindingType = (IntentAttachPointType)scaDefns.getBindingTypes().get(count);
            this.extensionProcessor.resolve((Object)bindingType, resolver);
        }
        size = scaDefns.getImplementationTypes().size();
        for (count = 0; count < size; ++count) {
            IntentAttachPointType implType = (IntentAttachPointType)scaDefns.getImplementationTypes().get(count);
            this.extensionProcessor.resolve((Object)implType, resolver);
        }
    }

    public QName getArtifactType() {
        return SCA_DEFINITIONS_QNAME;
    }

    public Class<SCADefinitions> getModelType() {
        return SCADefinitions.class;
    }
}

