/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;

public class XMLStreamReader2JAXB
extends BaseTransformer<XMLStreamReader, Object>
implements PullTransformer<XMLStreamReader, Object> {
    private JAXBContextHelper contextHelper;

    public XMLStreamReader2JAXB(ExtensionPointRegistry registry) {
        this.contextHelper = JAXBContextHelper.getInstance(registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object transform(XMLStreamReader source, TransformationContext context) {
        if (source == null) {
            return null;
        }
        JAXBContext jaxbContext = this.contextHelper.createJAXBContext(context, false);
        Unmarshaller unmarshaller = this.contextHelper.getUnmarshaller(jaxbContext);
        try {
            JAXBElement result = unmarshaller.unmarshal(source, JAXBContextHelper.getJavaType(context.getTargetDataType()));
            source.close();
            Object object = JAXBContextHelper.createReturnValue(jaxbContext, context.getTargetDataType(), result);
            this.contextHelper.releaseJAXBUnmarshaller(jaxbContext, unmarshaller);
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.contextHelper.releaseJAXBUnmarshaller(jaxbContext, unmarshaller);
                throw throwable;
            }
            catch (Exception e) {
                throw new TransformationException((Throwable)e);
            }
        }
    }

    public Class<XMLStreamReader> getSourceType() {
        return XMLStreamReader.class;
    }

    public Class<Object> getTargetType() {
        return Object.class;
    }

    public int getWeight() {
        return 10;
    }

    public String getTargetDataBinding() {
        return JAXBDataBinding.NAME;
    }
}

