/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;
import org.w3c.dom.Node;

public class Node2JAXB
extends BaseTransformer<Node, Object>
implements PullTransformer<Node, Object> {
    private JAXBContextHelper contextHelper;

    public Node2JAXB(ExtensionPointRegistry registry) {
        this.contextHelper = JAXBContextHelper.getInstance(registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object transform(Node source, TransformationContext context) {
        ValidationEventCollector validationEventCollector = new ValidationEventCollector();
        Object response = null;
        if (source == null) {
            return null;
        }
        try {
            JAXBElement result;
            JAXBContext jaxbContext = this.contextHelper.createJAXBContext(context, false);
            Node node = source;
            synchronized (node) {
                Unmarshaller unmarshaller = this.contextHelper.getUnmarshaller(jaxbContext);
                try {
                    validationEventCollector.reset();
                    unmarshaller.setEventHandler((ValidationEventHandler)validationEventCollector);
                    result = unmarshaller.unmarshal(source, JAXBContextHelper.getJavaType(context.getTargetDataType()));
                }
                finally {
                    this.contextHelper.releaseJAXBUnmarshaller(jaxbContext, unmarshaller);
                }
            }
            response = JAXBContextHelper.createReturnValue(jaxbContext, context.getTargetDataType(), result);
        }
        catch (Exception e) {
            throw new TransformationException((Throwable)e);
        }
        if (validationEventCollector.hasEvents()) {
            String validationErrors = "";
            for (ValidationEvent event : validationEventCollector.getEvents()) {
                validationErrors = validationErrors + "Event: " + event.getMessage() + " ";
            }
            throw new TransformationException(validationErrors);
        }
        return response;
    }

    protected Class<Node> getSourceType() {
        return Node.class;
    }

    protected Class<Object> getTargetType() {
        return Object.class;
    }

    public int getWeight() {
        return 30;
    }

    public String getTargetDataBinding() {
        return JAXBDataBinding.NAME;
    }
}

