/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.tuscany.sca.common.java.collection.LRUCache;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ClassLoaderContext;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.oasisopen.sca.ServiceRuntimeException;

public class JAXBContextCache {
    private static final int CACHE_SIZE = 128;
    private static HashMap<String, Class<?>> loadClassMap = new HashMap();
    protected static Class<?>[] JAXB_BUILTIN_CLASSES;
    protected static final Set<Class<?>> BUILTIN_CLASSES_SET;
    protected LRUCache<Object, JAXBContext> cache;
    protected Pool<JAXBContext, Marshaller> mpool;
    protected Pool<JAXBContext, Unmarshaller> upool;
    protected JAXBContext defaultContext;
    private ExtensionPointRegistry registry;

    public JAXBContextCache(ExtensionPointRegistry registry) {
        this(128, 128, 128, registry);
    }

    public JAXBContextCache(int contextSize, int marshallerSize, int unmarshallerSize, ExtensionPointRegistry registry) {
        this.registry = registry;
        this.cache = new LRUCache(contextSize);
        this.mpool = new Pool();
        this.upool = new Pool();
        this.defaultContext = this.getDefaultJAXBContext();
    }

    private JAXBContext newJAXBContext(final Class<?> ... classesToBeBound) throws JAXBException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public JAXBContext run() throws JAXBException {
                    ClassLoader tccl = ClassLoaderContext.setContextClassLoader((ClassLoader)JAXBContextCache.class.getClassLoader(), (ServiceDiscovery)JAXBContextCache.this.registry.getServiceDiscovery(), (String[])new String[]{JAXBContext.class.getName(), DatatypeFactory.class.getName()});
                    try {
                        JAXBContext context;
                        JAXBContext jAXBContext = context = JAXBContext.newInstance((Class[])classesToBeBound);
                        return jAXBContext;
                    }
                    finally {
                        if (tccl != null) {
                            Thread.currentThread().setContextClassLoader(tccl);
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (JAXBException)e.getException();
        }
    }

    public JAXBContext getDefaultJAXBContext() {
        try {
            return this.newJAXBContext(new Class[0]);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Class<?> getPrimitiveClass(String text) {
        return loadClassMap.get(text);
    }

    private static Class<?> forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    Class<?> cls = JAXBContextCache.getPrimitiveClass(className);
                    if (cls == null) {
                        cls = Class.forName(className, initialize, classloader);
                    }
                    return cls;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    public Marshaller getMarshaller(JAXBContext context) throws JAXBException {
        Marshaller marshaller = this.mpool.get(context);
        if (marshaller == null) {
            marshaller = context.createMarshaller();
        }
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return marshaller;
    }

    public void releaseJAXBMarshaller(JAXBContext context, Marshaller marshaller) {
        if (marshaller != null) {
            marshaller.setAttachmentMarshaller(null);
            this.mpool.put(context, marshaller);
        }
    }

    public Unmarshaller getUnmarshaller(JAXBContext context) throws JAXBException {
        Unmarshaller unmarshaller = this.upool.get(context);
        if (unmarshaller == null) {
            unmarshaller = context.createUnmarshaller();
        }
        return unmarshaller;
    }

    public void releaseJAXBUnmarshaller(JAXBContext context, Unmarshaller unmarshaller) {
        if (unmarshaller != null) {
            unmarshaller.setAttachmentUnmarshaller(null);
            this.upool.put(context, unmarshaller);
        }
    }

    public LRUCache<Object, JAXBContext> getCache() {
        return this.cache;
    }

    public JAXBContext getJAXBContext(Class<?> cls) throws JAXBException {
        if (BUILTIN_CLASSES_SET.contains(cls)) {
            return this.defaultContext;
        }
        return this.getJAXBContext(new Class[]{cls});
    }

    public JAXBContext getJAXBContext(Class<?>[] classes) throws JAXBException {
        HashSet classSet = new HashSet(Arrays.asList(classes));
        return this.getJAXBContext(classSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getJAXBContext(Set<Class<?>> classes) throws JAXBException {
        Set<Class<?>> classSet = new HashSet(classes);
        classSet.removeAll(BUILTIN_CLASSES_SET);
        if (classSet.contains(Date[].class)) {
            classSet.remove(Calendar[].class);
        }
        if (classSet.contains(URI[].class)) {
            classSet.remove(UUID[].class);
        }
        if (classSet.contains(Source[].class)) {
            classSet.remove(Image[].class);
            classSet.remove(DataHandler[].class);
        }
        if ((classSet = JAXBContextCache.getJAXBClasses(classSet)).isEmpty()) {
            return this.defaultContext;
        }
        LRUCache<Object, JAXBContext> lRUCache = this.cache;
        synchronized (lRUCache) {
            JAXBContext context = (JAXBContext)this.cache.get(classSet);
            if (context != null) {
                return context;
            }
            context = this.newJAXBContext(classSet.toArray(new Class[classSet.size()]));
            this.cache.put(classSet, (Object)context);
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LRUCache<Object, JAXBContext> lRUCache = this.cache;
        synchronized (lRUCache) {
            this.cache.clear();
        }
    }

    private static Set<Class<?>> getJAXBClasses(Collection<Class<?>> classes) throws JAXBException {
        Package pkg;
        HashSet classSet = new HashSet();
        Map<Package, ClassLoader> pkgs = JAXBContextCache.getPackages(classes);
        HashSet<Package> nonJAXBPackages = new HashSet<Package>();
        for (Map.Entry<Package, ClassLoader> entry : pkgs.entrySet()) {
            pkg = entry.getKey();
            if (pkg == null) continue;
            Set<Class<?>> set = JAXBContextCache.getJAXBClasses(pkg.getName(), entry.getValue());
            if (set.isEmpty()) {
                nonJAXBPackages.add(pkg);
                continue;
            }
            classSet.addAll(set);
        }
        for (Class clazz : classes) {
            pkg = JAXBContextCache.getPackage(clazz);
            if (pkg == null || nonJAXBPackages.contains(pkg)) {
                classSet.add(clazz);
                continue;
            }
            if (clazz.isAnnotationPresent(XmlType.class) || clazz.isAnnotationPresent(XmlEnum.class) || clazz.isAnnotationPresent(XmlSeeAlso.class) || clazz.isAnnotationPresent(XmlRootElement.class) || clazz.isAnnotationPresent(XmlTransient.class)) continue;
            classSet.add(clazz);
        }
        return classSet;
    }

    private static Package getPackage(Class<?> cls) {
        Class<?> type = cls;
        while (type.isArray()) {
            type = type.getComponentType();
        }
        return type.getPackage();
    }

    private static Map<Package, ClassLoader> getPackages(Collection<Class<?>> classes) {
        HashMap<Package, ClassLoader> pkgs = new HashMap<Package, ClassLoader>();
        for (Class<?> cls : classes) {
            Package pkg = JAXBContextCache.getPackage(cls);
            if (pkg == null) continue;
            final Class<?> fcls = cls;
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader cl = fcls.getClassLoader();
                    return cl;
                }
            });
            pkgs.put(pkg, cl);
        }
        return pkgs;
    }

    private static Set<Class<?>> getJAXBClasses(String pkg, ClassLoader classLoader) throws JAXBException {
        List<Class<?>> indexedClasses;
        HashSet classes = new HashSet();
        try {
            Class<?> o = JAXBContextCache.forName(pkg + ".ObjectFactory", false, classLoader);
            classes.add(o);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            indexedClasses = JAXBContextCache.loadIndexedClasses(pkg, classLoader);
        }
        catch (IOException e) {
            throw new JAXBException((Throwable)e);
        }
        if (indexedClasses != null) {
            classes.addAll(indexedClasses);
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Class<?>> loadIndexedClasses(String pkg, ClassLoader classLoader) throws IOException, JAXBException {
        if (classLoader == null) {
            return null;
        }
        String resource = pkg.replace('.', '/') + "/jaxb.index";
        InputStream resourceAsStream = classLoader.getResourceAsStream(resource);
        if (resourceAsStream == null) {
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(resourceAsStream, "UTF-8"));
        try {
            ArrayList classes = new ArrayList();
            String className = in.readLine();
            while (className != null) {
                if ((className = className.trim()).startsWith("#") || className.length() == 0) {
                    className = in.readLine();
                    continue;
                }
                try {
                    classes.add(JAXBContextCache.forName(pkg + '.' + className, false, classLoader));
                }
                catch (ClassNotFoundException e) {
                    throw new JAXBException((Throwable)e);
                }
                className = in.readLine();
            }
            ArrayList arrayList = classes;
            return arrayList;
        }
        finally {
            in.close();
        }
    }

    public void removeJAXBContextFromPools(JAXBContext ctx) {
        if (this.mpool != null && ctx != null) {
            this.mpool.removeCtx(ctx);
        }
        if (this.upool != null && ctx != null) {
            this.upool.removeCtx(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJAXBContextForContribution(ClassLoader contributionClassloader) {
        if (this.cache != null) {
            try {
                LRUCache<Object, JAXBContext> lRUCache = this.cache;
                synchronized (lRUCache) {
                    Set objSet = this.cache.keySet();
                    ArrayList toRemove = new ArrayList();
                    block5: for (Object obj : objSet) {
                        if (!(obj instanceof Set)) continue;
                        Set innerSet = (Set)obj;
                        for (Class cls : innerSet) {
                            for (ClassLoader cl = cls.getClassLoader(); cl != null; cl = cl.getParent()) {
                                if (cl != contributionClassloader) continue;
                                toRemove.add(obj);
                                continue block5;
                            }
                        }
                    }
                    for (Object obj : toRemove) {
                        JAXBContext ctx = (JAXBContext)this.cache.get(obj);
                        this.removeJAXBContextFromPools(ctx);
                        this.cache.remove(obj);
                    }
                }
            }
            catch (Exception e) {
                throw new ServiceRuntimeException((Throwable)e);
            }
        }
    }

    static {
        loadClassMap.put("byte", Byte.TYPE);
        loadClassMap.put("int", Integer.TYPE);
        loadClassMap.put("short", Short.TYPE);
        loadClassMap.put("long", Long.TYPE);
        loadClassMap.put("float", Float.TYPE);
        loadClassMap.put("double", Double.TYPE);
        loadClassMap.put("boolean", Boolean.TYPE);
        loadClassMap.put("char", Character.TYPE);
        loadClassMap.put("void", Void.TYPE);
        JAXB_BUILTIN_CLASSES = new Class[]{byte[].class, Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE, Image.class, File.class, Boolean.class, Byte.class, Character.class, Class.class, Double.class, Float.class, Integer.class, Long.class, Object.class, Short.class, String.class, Void.class, BigDecimal.class, BigInteger.class, URI.class, URL.class, Calendar.class, Date.class, GregorianCalendar.class, UUID.class, DataHandler.class, JAXBElement.class, Duration.class, XMLGregorianCalendar.class, QName.class, Source.class};
        BUILTIN_CLASSES_SET = new HashSet(Arrays.asList(JAXB_BUILTIN_CLASSES));
    }

    private static class Pool<K, V> {
        private SoftReference<Map<K, List<V>>> softMap = new SoftReference(new ConcurrentHashMap());
        private static final int MAX_LIST_FACTOR = 50;
        private static final int MAX_LOAD_FACTOR = 32;

        private Pool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key) {
            List<V> values;
            List<V> list = values = this.getValues(key);
            synchronized (list) {
                if (values.size() > 0) {
                    V v = values.remove(values.size() - 1);
                    return v;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K key, V value) {
            List<V> values;
            this.adjustSize();
            List<V> list = values = this.getValues(key);
            synchronized (list) {
                if (values.size() < 50) {
                    values.add(value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<V> getValues(K key) {
            Map<K, List<List<V>>> map = this.softMap.get();
            List<V> values = null;
            if (map != null && (values = map.get(key)) != null) {
                return values;
            }
            Pool pool = this;
            synchronized (pool) {
                if (map != null) {
                    values = map.get(key);
                }
                if (values == null) {
                    if (map == null) {
                        map = new ConcurrentHashMap<K, List<V>>();
                        this.softMap = new SoftReference<Map<K, List<V>>>(map);
                    }
                    values = new ArrayList<V>();
                    map.put(key, values);
                }
                return values;
            }
        }

        private void adjustSize() {
            Map<K, List<V>> map = this.softMap.get();
            if (map != null && map.size() > 32) {
                Iterator<Map.Entry<K, List<V>>> it = map.entrySet().iterator();
                boolean removeIt = false;
                while (it.hasNext()) {
                    it.next();
                    if (removeIt) {
                        it.remove();
                    }
                    removeIt = !removeIt;
                }
            }
        }

        public void removeCtx(K key) {
            Map<K, List<V>> map = this.softMap.get();
            if (map != null && key != null) {
                map.remove(key);
            }
        }
    }
}

