/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.PushTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;
import org.xml.sax.ContentHandler;

public class JAXB2SAX
extends BaseTransformer<Object, ContentHandler>
implements PushTransformer<Object, ContentHandler> {
    private JAXBContextHelper contextHelper;

    public JAXB2SAX(ExtensionPointRegistry registry) {
        this.contextHelper = JAXBContextHelper.getInstance(registry);
    }

    protected Class<Object> getSourceType() {
        return Object.class;
    }

    protected Class<ContentHandler> getTargetType() {
        return ContentHandler.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(Object source, ContentHandler target, TransformationContext tContext) {
        try {
            JAXBContext context = this.contextHelper.createJAXBContext(tContext, true);
            Object jaxbElement = JAXBContextHelper.createJAXBElement(context, tContext.getSourceDataType(), source);
            Marshaller marshaller = this.contextHelper.getMarshaller(context);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
            try {
                marshaller.marshal(jaxbElement, target);
            }
            finally {
                this.contextHelper.releaseJAXBMarshaller(context, marshaller);
            }
        }
        catch (Exception e) {
            throw new TransformationException((Throwable)e);
        }
    }

    public int getWeight() {
        return 20;
    }

    public String getSourceDataBinding() {
        return JAXBDataBinding.NAME;
    }
}

