/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.PushTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;

public class JAXB2OutputStream
extends BaseTransformer<Object, OutputStream>
implements PushTransformer<Object, OutputStream> {
    private JAXBContextHelper contextHelper;

    public JAXB2OutputStream(ExtensionPointRegistry registry) {
        this.contextHelper = JAXBContextHelper.getInstance(registry);
    }

    protected Class<Object> getSourceType() {
        return Object.class;
    }

    protected Class<OutputStream> getTargetType() {
        return OutputStream.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(Object source, OutputStream target, TransformationContext tContext) {
        try {
            JAXBContext context = this.contextHelper.createJAXBContext(tContext, true);
            Object jaxbElement = JAXBContextHelper.createJAXBElement(context, tContext.getSourceDataType(), source);
            Marshaller marshaller = this.contextHelper.getMarshaller(context);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
            try {
                marshaller.marshal(jaxbElement, target);
            }
            finally {
                this.contextHelper.releaseJAXBMarshaller(context, marshaller);
            }
        }
        catch (Exception e) {
            throw new TransformationException((Throwable)e);
        }
    }

    public int getWeight() {
        return 20;
    }

    public String getSourceDataBinding() {
        return JAXBDataBinding.NAME;
    }
}

