/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.activation.DataHandler;
import javax.imageio.ImageIO;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.oasisopen.sca.ServiceRuntimeException;

public class DataConverter {
    public static boolean isConvertable(Object obj, Class dest) {
        Class<?> src = null;
        if (obj != null) {
            src = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        }
        if (dest == null) {
            return false;
        }
        if (src == null) {
            return true;
        }
        if (dest.isAssignableFrom(src)) {
            return true;
        }
        if (DataConverter.getWrapperClass(src) == dest) {
            return true;
        }
        if (DataConverter.getWrapperClass(dest) == src) {
            return true;
        }
        if ((Collection.class.isAssignableFrom(src) || src.isArray()) && (Collection.class.isAssignableFrom(dest) || dest.isArray())) {
            return true;
        }
        if (src == HashMap.class && dest == Hashtable.class) {
            return true;
        }
        if (Calendar.class.isAssignableFrom(src) && dest == Date.class) {
            return true;
        }
        if (src.isPrimitive()) {
            return DataConverter.isConvertable(DataConverter.getWrapperClass(src), dest);
        }
        if (InputStream.class.isAssignableFrom(src) && dest == byte[].class) {
            return true;
        }
        if (Source.class.isAssignableFrom(src) && dest == byte[].class) {
            return true;
        }
        if (DataHandler.class.isAssignableFrom(src) && DataConverter.isConvertable(byte[].class, dest)) {
            return true;
        }
        if (DataHandler.class.isAssignableFrom(src) && dest == Image.class) {
            return true;
        }
        if (DataHandler.class.isAssignableFrom(src) && dest == Source.class) {
            return true;
        }
        return byte[].class.isAssignableFrom(src) && dest == String.class;
    }

    public static Object convert(Object arg, Class<?> destClass) {
        Object destValue;
        block40: {
            if (destClass == null) {
                return arg;
            }
            if (arg != null && destClass.isAssignableFrom(arg.getClass())) {
                return arg;
            }
            if (arg instanceof Calendar && destClass == Date.class) {
                return ((Calendar)arg).getTime();
            }
            if (arg instanceof HashMap && destClass == Hashtable.class) {
                return new Hashtable((HashMap)arg);
            }
            if (arg instanceof InputStream && destClass == byte[].class) {
                try {
                    InputStream is = (InputStream)arg;
                    return DataConverter.getBytesFromStream(is);
                }
                catch (IOException e) {
                    throw new ServiceRuntimeException((Throwable)e);
                }
            }
            if (arg instanceof Source && destClass == byte[].class) {
                try {
                    InputStream is;
                    if (arg instanceof StreamSource && (is = ((StreamSource)arg).getInputStream()) != null) {
                        return DataConverter.getBytesFromStream(is);
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    StreamResult result = new StreamResult(out);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.transform((Source)arg, result);
                    byte[] bytes = out.toByteArray();
                    return bytes;
                }
                catch (Exception e) {
                    throw new ServiceRuntimeException((Throwable)e);
                }
            }
            if (arg instanceof DataHandler) {
                try {
                    InputStream is = ((DataHandler)arg).getInputStream();
                    if (destClass == Image.class) {
                        return ImageIO.read(is);
                    }
                    if (destClass == Source.class) {
                        return new StreamSource(is);
                    }
                    byte[] bytes = DataConverter.getBytesFromStream(is);
                    return DataConverter.convert(bytes, destClass);
                }
                catch (Exception e) {
                    throw new ServiceRuntimeException((Throwable)e);
                }
            }
            if (arg instanceof byte[] && destClass == String.class) {
                return new String((byte[])arg);
            }
            if (!(arg instanceof Collection || arg != null && arg.getClass().isArray())) {
                return arg;
            }
            if (arg == null) {
                return null;
            }
            destValue = null;
            int length = 0;
            length = arg.getClass().isArray() ? Array.getLength(arg) : ((Collection)arg).size();
            try {
                if (destClass.isArray()) {
                    Object[] array;
                    if (destClass.getComponentType().isPrimitive()) {
                        Object array2 = Array.newInstance(destClass.getComponentType(), length);
                        if (arg.getClass().isArray()) {
                            for (int i = 0; i < length; ++i) {
                                Array.set(array2, i, Array.get(arg, i));
                            }
                        } else {
                            int idx = 0;
                            Iterator i = ((Collection)arg).iterator();
                            while (i.hasNext()) {
                                Array.set(array2, idx++, i.next());
                            }
                        }
                        destValue = array2;
                        break block40;
                    }
                    try {
                        array = (Object[])Array.newInstance(destClass.getComponentType(), length);
                    }
                    catch (Exception e) {
                        return arg;
                    }
                    if (arg.getClass().isArray()) {
                        for (int i = 0; i < length; ++i) {
                            array[i] = DataConverter.convert(Array.get(arg, i), destClass.getComponentType());
                        }
                    } else {
                        int idx = 0;
                        Iterator i = ((Collection)arg).iterator();
                        while (i.hasNext()) {
                            array[idx++] = DataConverter.convert(i.next(), destClass.getComponentType());
                        }
                    }
                    destValue = array;
                    break block40;
                }
                if (Collection.class.isAssignableFrom(destClass)) {
                    Collection newList = null;
                    try {
                        newList = destClass == Collection.class || destClass == List.class ? new ArrayList() : (destClass == Set.class ? new HashSet() : (Collection)destClass.newInstance());
                    }
                    catch (Exception e) {
                        return arg;
                    }
                    if (arg.getClass().isArray()) {
                        for (int j = 0; j < length; ++j) {
                            newList.add(Array.get(arg, j));
                        }
                    } else {
                        Iterator j = ((Collection)arg).iterator();
                        while (j.hasNext()) {
                            newList.add(j.next());
                        }
                    }
                    destValue = newList;
                    break block40;
                }
                destValue = arg;
            }
            catch (Throwable t) {
                throw new ServiceRuntimeException(t);
            }
        }
        return destValue;
    }

    private static byte[] getBytesFromStream(InputStream is) throws IOException {
        byte[] bytes = new byte[is.available()];
        is.read(bytes);
        return bytes;
    }

    public static Class getWrapperClass(Class primitive) {
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        return null;
    }
}

