/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb.axiom.ext;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.tuscany.sca.databinding.jaxb.axiom.ext.JAXBDSContext;
import org.apache.tuscany.sca.databinding.jaxb.axiom.ext.JAXBDataSourceExt;

public class JAXBCustomBuilder
implements CustomBuilder {
    private JAXBDSContext jdsContext;
    public static final String URI_NS_SOAP_1_1_ENVELOPE = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String URI_NS_SOAP_1_2_ENVELOPE = "http://www.w3.org/2003/05/soap-envelope";

    public JAXBCustomBuilder(JAXBDSContext context) {
        this.jdsContext = context;
    }

    public OMElement create(String namespace, String localPart, OMContainer parent, XMLStreamReader reader, OMFactory factory) throws OMException {
        if (!this.shouldUnmarshal(namespace, localPart)) {
            return null;
        }
        try {
            OMNamespace ns = factory.createOMNamespace(namespace, reader.getPrefix());
            Object jaxb = this.jdsContext.unmarshal(reader);
            JAXBDataSourceExt ds = new JAXBDataSourceExt(jaxb, this.jdsContext);
            OMSourcedElement omse = factory.createOMElement((OMDataSource)ds, localPart, ns);
            parent.addChild((OMNode)omse);
            return omse;
        }
        catch (JAXBException e) {
            throw new OMException((Throwable)e);
        }
    }

    private boolean shouldUnmarshal(String namespace, String localPart) {
        if (localPart == null || namespace == null || namespace.length() == 0 || URI_NS_SOAP_1_1_ENVELOPE.equals(namespace) || URI_NS_SOAP_1_2_ENVELOPE.equals(namespace)) {
            return false;
        }
        return !localPart.equals("EncryptedData");
    }
}

