/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb.axiom;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;
import org.apache.tuscany.sca.databinding.jaxb.axiom.AxiomHelper;
import org.apache.tuscany.sca.databinding.jaxb.axiom.JAXBDataSource;
import org.apache.tuscany.sca.interfacedef.DataType;

public class JAXB2OMElement
extends BaseTransformer<Object, OMElement>
implements PullTransformer<Object, OMElement> {
    private OMFactory factory = OMAbstractFactory.getOMFactory();
    private JAXBContextHelper contextHelper;

    public JAXB2OMElement(ExtensionPointRegistry registry) {
        this.contextHelper = JAXBContextHelper.getInstance((ExtensionPointRegistry)registry);
    }

    public String getSourceDataBinding() {
        return JAXBDataBinding.NAME;
    }

    public OMElement transform(Object source, TransformationContext context) throws TransformationException {
        JAXBContext jaxbContext;
        try {
            jaxbContext = this.contextHelper.createJAXBContext(context, true);
        }
        catch (JAXBException e) {
            throw new TransformationException((Throwable)e);
        }
        Object element = JAXBContextHelper.createJAXBElement((JAXBContext)jaxbContext, (DataType)context.getTargetDataType(), (Object)source);
        QName name = jaxbContext.createJAXBIntrospector().getElementName(element);
        JAXBDataSource dataSource = new JAXBDataSource(element, jaxbContext, this.contextHelper);
        OMElement omElement = AxiomHelper.createOMElement(this.factory, name, dataSource);
        return omElement;
    }

    public Class<Object> getSourceType() {
        return Object.class;
    }

    public Class<OMElement> getTargetType() {
        return OMElement.class;
    }

    public int getWeight() {
        return 3000;
    }
}

