/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.common.java.io.IOHelper;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class ContributionMetadataDocumentProcessor
implements URLArtifactProcessor<ContributionMetadata> {
    private final StAXArtifactProcessor staxProcessor;
    private final XMLInputFactory inputFactory;

    public ContributionMetadataDocumentProcessor(XMLInputFactory inputFactory, StAXArtifactProcessor staxProcessor) {
        this.inputFactory = inputFactory;
        this.staxProcessor = staxProcessor;
    }

    public ContributionMetadataDocumentProcessor(FactoryExtensionPoint modelFactories, StAXArtifactProcessor staxProcessor) {
        this.inputFactory = (XMLInputFactory)modelFactories.getFactory(ValidatingXMLInputFactory.class);
        this.staxProcessor = staxProcessor;
    }

    @Override
    public String getArtifactType() {
        return "/META-INF/sca-contribution.xml";
    }

    @Override
    public Class<ContributionMetadata> getModelType() {
        return ContributionMetadata.class;
    }

    @Override
    public ContributionMetadata read(URL contributionURL, URI uri, URL url, ProcessorContext context) throws ContributionReadException {
        InputStream urlStream = null;
        try {
            ContributionMetadata contribution;
            urlStream = IOHelper.openStream((URL)url);
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(url.toString(), urlStream);
            ValidatingXMLInputFactory.setMonitor(reader, context.getMonitor());
            reader.nextTag();
            ContributionMetadata contributionMetadata = contribution = (ContributionMetadata)this.staxProcessor.read(reader, context);
            return contributionMetadata;
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException(e);
            this.error(context.getMonitor(), "XMLStreamException", this.inputFactory, ex);
            throw ex;
        }
        catch (IOException e) {
            ContributionReadException ex = new ContributionReadException(e);
            this.error(context.getMonitor(), "IOException", this.inputFactory, ex);
            throw ex;
        }
        finally {
            try {
                if (urlStream != null) {
                    urlStream.close();
                    urlStream = null;
                }
            }
            catch (IOException ioe) {}
        }
    }

    @Override
    public void resolve(ContributionMetadata contribution, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        this.staxProcessor.resolve(contribution, resolver, context);
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-xml-validation-messages", Problem.Severity.ERROR, model, message, (Throwable)ex);
            monitor.problem(problem);
        }
    }
}

