/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.scanner;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.scanner.ContributionScanner;
import org.apache.tuscany.sca.contribution.scanner.ContributionScannerExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;

public class DefaultContributionScannerExtensionPoint
implements ContributionScannerExtensionPoint {
    private Map<String, ContributionScanner> scanners = new HashMap<String, ContributionScanner>();
    private boolean loaded;
    private ExtensionPointRegistry registry;

    public DefaultContributionScannerExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void addContributionScanner(ContributionScanner scanner) {
        this.scanners.put(scanner.getContributionType(), scanner);
    }

    @Override
    public void removeContributionScanner(ContributionScanner scanner) {
        this.scanners.remove(scanner.getContributionType());
    }

    @Override
    public ContributionScanner getContributionScanner(String contentType) {
        this.loadScanners();
        return this.scanners.get(contentType);
    }

    private synchronized void loadScanners() {
        Collection scannerDeclarations;
        if (this.loaded) {
            return;
        }
        try {
            scannerDeclarations = this.registry.getServiceDiscovery().getServiceDeclarations(ContributionScanner.class.getName());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration scannerDeclaration : scannerDeclarations) {
            Map attributes = scannerDeclaration.getAttributes();
            String contributionType = (String)attributes.get("type");
            LazyContributionScanner scanner = new LazyContributionScanner(this.registry, contributionType, scannerDeclaration);
            this.addContributionScanner(scanner);
        }
        this.loaded = true;
    }

    private static class LazyContributionScanner
    implements ContributionScanner {
        private ExtensionPointRegistry registry;
        private ServiceDeclaration scannerDeclaration;
        private String contributionType;
        private ContributionScanner scanner;
        private ContributionFactory contributionFactory;

        private LazyContributionScanner(ExtensionPointRegistry registry, String contributionType, ServiceDeclaration scannerDeclaration) {
            this.registry = registry;
            this.scannerDeclaration = scannerDeclaration;
            this.contributionType = contributionType;
            FactoryExtensionPoint factories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
            this.contributionFactory = (ContributionFactory)factories.getFactory(ContributionFactory.class);
        }

        @Override
        public List<Artifact> scan(Contribution contributionSourceURL) throws ContributionReadException {
            return this.getScanner().scan(contributionSourceURL);
        }

        @Override
        public String getContributionType() {
            return this.contributionType;
        }

        private ContributionScanner getScanner() {
            if (this.scanner == null) {
                try {
                    Class scannerClass = this.scannerDeclaration.loadClass();
                    Constructor constructor = scannerClass.getConstructor(ContributionFactory.class);
                    this.scanner = (ContributionScanner)constructor.newInstance(this.contributionFactory);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.scanner;
        }
    }
}

