/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.UnrecognizedElementException;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class ExtensibleStAXArtifactProcessor
implements StAXArtifactProcessor<Object> {
    private static final Logger logger = Logger.getLogger(ExtensibleStAXArtifactProcessor.class.getName());
    private static final String XMLSCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    public static final QName ANY_ELEMENT = new QName("http://www.w3.org/2001/XMLSchema", "any");
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private StAXArtifactProcessorExtensionPoint processors;

    public ExtensibleStAXArtifactProcessor(StAXArtifactProcessorExtensionPoint processors, XMLInputFactory inputFactory, XMLOutputFactory outputFactory) {
        this.processors = processors;
        this.inputFactory = inputFactory;
        this.outputFactory = outputFactory;
        if (this.outputFactory != null) {
            this.outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        }
    }

    public ExtensibleStAXArtifactProcessor(ExtensionPointRegistry registry) {
        this.processors = (StAXArtifactProcessorExtensionPoint)registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        FactoryExtensionPoint factories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.inputFactory = (XMLInputFactory)factories.getFactory(XMLInputFactory.class);
        this.outputFactory = (XMLOutputFactory)factories.getFactory(XMLOutputFactory.class);
        if (this.outputFactory != null) {
            this.outputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        }
    }

    private void warning(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, (Throwable)ex);
            monitor.problem(problem);
        }
    }

    @Override
    public Object read(XMLStreamReader source, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        QName name;
        StAXArtifactProcessor processor;
        Monitor monitor = context.getMonitor();
        int event = source.getEventType();
        if (event == 7) {
            while (source.next() != 1) {
            }
        }
        if ((processor = this.processors.getProcessor(name = source.getName())) == null) {
            Location location = source.getLocation();
            this.error(monitor, "ElementCannotBeProcessed", (Object)this.processors, name, location);
            StAXArtifactProcessor anyElementProcessor = this.processors.getProcessor(ANY_ELEMENT);
            if (anyElementProcessor != null) {
                return anyElementProcessor.read(source, context);
            }
            return null;
        }
        return processor.read(source, context);
    }

    @Override
    public void write(Object model, XMLStreamWriter outputSource, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        if (model != null) {
            StAXArtifactProcessor<?> processor = this.processors.getProcessor(model.getClass());
            if (processor != null) {
                processor.write(model, outputSource, context);
            } else {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning("No StAX processor is configured to handle " + model.getClass());
                }
                StAXArtifactProcessor anyElementProcessor = this.processors.getProcessor(ANY_ELEMENT);
                if (model instanceof Extension && anyElementProcessor != null) {
                    anyElementProcessor.write(model, outputSource, context);
                }
            }
        }
    }

    @Override
    public void resolve(Object model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        StAXArtifactProcessor<?> processor;
        if (model != null && (processor = this.processors.getProcessor(model.getClass())) != null) {
            processor.resolve(model, resolver, context);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <M> M read(InputStream is, Class<M> type, ProcessorContext context) throws ContributionReadException {
        Monitor monitor = context.getMonitor();
        try {
            try {
                XMLStreamReader reader = this.inputFactory.createXMLStreamReader(is);
                try {
                    reader.nextTag();
                    QName name = reader.getName();
                    Object mo = this.read(reader, context);
                    if (type.isInstance(mo)) {
                        M m = type.cast(mo);
                        return m;
                    }
                    this.error(monitor, "UnrecognizedElementException", (Object)reader, name);
                    UnrecognizedElementException e = new UnrecognizedElementException(name);
                    throw e;
                }
                catch (ContributionReadException e) {
                    Location location = reader.getLocation();
                    e.setLine(location.getLineNumber());
                    e.setColumn(location.getColumnNumber());
                    this.error(monitor, "ContributionReadException", (Object)reader, e);
                    throw e;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException e) {}
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error(monitor, "ContributionReadException", (Object)this.inputFactory, ce);
            throw ce;
        }
    }

    public void write(Object model, OutputStream os, ProcessorContext context) throws ContributionWriteException {
        try {
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(os);
            this.write(model, writer, context);
            writer.flush();
            writer.close();
        }
        catch (XMLStreamException e) {
            ContributionWriteException cw = new ContributionWriteException(e);
            this.error(context.getMonitor(), "ContributionWriteException", (Object)this.outputFactory, cw);
            throw cw;
        }
    }

    @Override
    public QName getArtifactType() {
        return null;
    }

    @Override
    public Class<Object> getModelType() {
        return null;
    }
}

