/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.DefaultArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDeclarationParser;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.monitor.Problem;

public class DefaultStAXAttributeProcessorExtensionPoint
extends DefaultArtifactProcessorExtensionPoint<StAXAttributeProcessor<?>>
implements StAXAttributeProcessorExtensionPoint {
    private FactoryExtensionPoint modelFactories;
    private StAXAttributeProcessor<Object> extensibleStAXAttributeProcessor;
    private boolean loaded;
    private Monitor monitor = null;

    public DefaultStAXAttributeProcessorExtensionPoint(ExtensionPointRegistry extensionPoints) {
        super(extensionPoints);
        this.modelFactories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        XMLInputFactory inputFactory = (XMLInputFactory)this.modelFactories.getFactory(XMLInputFactory.class);
        XMLOutputFactory outputFactory = (XMLOutputFactory)this.modelFactories.getFactory(XMLOutputFactory.class);
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)this.registry.getExtensionPoint(UtilityExtensionPoint.class);
        MonitorFactory monitorFactory = (MonitorFactory)utilities.getUtility(MonitorFactory.class);
        if (monitorFactory != null) {
            this.monitor = monitorFactory.createMonitor();
        }
        this.extensibleStAXAttributeProcessor = new ExtensibleStAXAttributeProcessor(this, inputFactory, outputFactory);
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            Problem problem = this.monitor.createProblem(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, (Throwable)ex);
            this.monitor.problem(problem);
        }
    }

    @Override
    public void addArtifactProcessor(StAXAttributeProcessor<?> artifactProcessor) {
        if (artifactProcessor.getArtifactType() != null) {
            this.processorsByArtifactType.put(artifactProcessor.getArtifactType(), artifactProcessor);
        }
        if (artifactProcessor.getModelType() != null) {
            this.processorsByModelType.put(artifactProcessor.getModelType(), artifactProcessor);
        }
    }

    @Override
    public void removeArtifactProcessor(StAXAttributeProcessor<?> artifactProcessor) {
        if (artifactProcessor.getArtifactType() != null) {
            this.processorsByArtifactType.remove(artifactProcessor.getArtifactType());
        }
        if (artifactProcessor.getModelType() != null) {
            this.processorsByModelType.remove(artifactProcessor.getModelType());
        }
    }

    @Override
    public <T> StAXAttributeProcessor<T> getProcessor(Class<T> modelType) {
        this.loadArtifactProcessors();
        return (StAXAttributeProcessor)super.getProcessor(modelType);
    }

    @Override
    public StAXAttributeProcessor<?> getProcessor(Object artifactType) {
        this.loadArtifactProcessors();
        return (StAXAttributeProcessor)super.getProcessor(artifactType);
    }

    private synchronized void loadArtifactProcessors() {
        Collection processorDeclarations;
        if (this.loaded) {
            return;
        }
        try {
            processorDeclarations = this.registry.getServiceDiscovery().getServiceDeclarations(StAXAttributeProcessor.class.getName());
        }
        catch (IOException e) {
            IllegalStateException ie = new IllegalStateException(e);
            this.error("IllegalStateException", this.extensibleStAXAttributeProcessor, ie);
            throw ie;
        }
        for (ServiceDeclaration processorDeclaration : processorDeclarations) {
            Map attributes = processorDeclaration.getAttributes();
            QName artifactType = ServiceDeclarationParser.getQName((String)((String)attributes.get("qname")));
            String modelTypeName = (String)attributes.get("model");
            String factoryName = (String)attributes.get("factory");
            LazyStAXAttributeProcessor processor = new LazyStAXAttributeProcessor(artifactType, modelTypeName, factoryName, processorDeclaration, this.registry, this.modelFactories, this.extensibleStAXAttributeProcessor);
            this.addArtifactProcessor(processor);
        }
        this.loaded = true;
    }

    private static class LazyStAXAttributeProcessor
    implements StAXAttributeProcessor {
        private ExtensionPointRegistry extensionPoints;
        private QName artifactType;
        private String modelTypeName;
        private String factoryName;
        private ServiceDeclaration processorDeclaration;
        private StAXAttributeProcessor<?> processor;
        private Class<?> modelType;
        private StAXAttributeProcessor<Object> extensionProcessor;

        LazyStAXAttributeProcessor(QName artifactType, String modelTypeName, String factoryName, ServiceDeclaration processorDeclaration, ExtensionPointRegistry extensionPoints, FactoryExtensionPoint modelFactories, StAXAttributeProcessor<Object> extensionProcessor) {
            this.extensionPoints = extensionPoints;
            this.artifactType = artifactType;
            this.modelTypeName = modelTypeName;
            this.factoryName = factoryName;
            this.processorDeclaration = processorDeclaration;
            this.extensionProcessor = extensionProcessor;
        }

        @Override
        public QName getArtifactType() {
            return this.artifactType;
        }

        private StAXAttributeProcessor getProcessor() {
            if (this.processor == null) {
                FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)this.extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
                try {
                    Class processorClass = this.processorDeclaration.loadClass();
                    try {
                        Constructor constructor = processorClass.getConstructor(FactoryExtensionPoint.class);
                        this.processor = (StAXAttributeProcessor)constructor.newInstance(modelFactories);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Constructor constructor = processorClass.getConstructor(ExtensionPointRegistry.class);
                            this.processor = (StAXAttributeProcessor)constructor.newInstance(this.extensionPoints);
                        }
                        catch (NoSuchMethodException e1) {
                            try {
                                Constructor constructor = processorClass.getConstructor(FactoryExtensionPoint.class, StAXArtifactProcessor.class);
                                this.processor = (StAXAttributeProcessor)constructor.newInstance(modelFactories, this.extensionProcessor);
                            }
                            catch (NoSuchMethodException e2) {
                                try {
                                    Constructor constructor = processorClass.getConstructor(ExtensionPointRegistry.class, StAXArtifactProcessor.class);
                                    this.processor = (StAXAttributeProcessor)constructor.newInstance(this.extensionPoints, this.extensionProcessor);
                                }
                                catch (NoSuchMethodException e3) {
                                    try {
                                        Constructor constructor = processorClass.getConstructor(FactoryExtensionPoint.class);
                                        this.processor = (StAXAttributeProcessor)constructor.newInstance(modelFactories);
                                    }
                                    catch (NoSuchMethodException e4) {
                                        try {
                                            Constructor constructor = processorClass.getConstructor(ExtensionPointRegistry.class);
                                            this.processor = (StAXAttributeProcessor)constructor.newInstance(this.extensionPoints);
                                        }
                                        catch (NoSuchMethodException e4a) {
                                            Constructor constructor = processorClass.getConstructor(new Class[0]);
                                            this.processor = (StAXAttributeProcessor)constructor.newInstance(new Object[0]);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    IllegalStateException ie = new IllegalStateException(e);
                    throw ie;
                }
            }
            return this.processor;
        }

        public Object read(QName attributeName, XMLStreamReader inputSource, ProcessorContext context) throws ContributionReadException, XMLStreamException {
            return this.getProcessor().read(attributeName, inputSource, context);
        }

        public void write(Object model, XMLStreamWriter outputSource, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
            this.getProcessor().write(model, outputSource, context);
        }

        @Override
        public Class<?> getModelType() {
            if (this.modelTypeName != null && this.modelType == null) {
                try {
                    this.modelType = this.processorDeclaration.loadClass(this.modelTypeName);
                }
                catch (Exception e) {
                    IllegalStateException ie = new IllegalStateException(e);
                    throw ie;
                }
            }
            return this.modelType;
        }

        @Override
        public void resolve(Object model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
            this.getProcessor().resolve(model, resolver, context);
        }
    }
}

