/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.namespace.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImportExportFactory;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class NamespaceImportProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<NamespaceImport> {
    private static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    private static final QName IMPORT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "import");
    private static final String NAMESPACE = "namespace";
    private static final String LOCATION = "location";
    private final NamespaceImportExportFactory factory;
    private final AssemblyFactory extensionFactory;
    private final StAXArtifactProcessor<Object> extensionProcessor;
    private final StAXAttributeProcessor<Object> attributeProcessor;

    public NamespaceImportProcessor(FactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> extensionProcessor, StAXAttributeProcessor<Object> attributeProcessor) {
        this.factory = (NamespaceImportExportFactory)modelFactories.getFactory(NamespaceImportExportFactory.class);
        this.extensionFactory = (AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
        this.extensionProcessor = extensionProcessor;
        this.attributeProcessor = attributeProcessor;
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-namespace-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return IMPORT;
    }

    @Override
    public Class<NamespaceImport> getModelType() {
        return NamespaceImport.class;
    }

    @Override
    public NamespaceImport read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException {
        NamespaceImport namespaceImport = this.factory.createNamespaceImport();
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        QName element = reader.getName();
                        if (IMPORT.equals(element)) {
                            String ns = reader.getAttributeValue(null, NAMESPACE);
                            if (ns == null) {
                                this.error(context.getMonitor(), "AttributeNameSpaceMissing", reader, new Object[0]);
                            } else {
                                namespaceImport.setNamespace(ns);
                            }
                            String location = this.getURIString(reader, LOCATION);
                            if (location != null) {
                                namespaceImport.setLocation(location);
                            }
                            this.readExtendedAttributes(reader, namespaceImport, this.attributeProcessor, this.extensionFactory, context);
                            break;
                        }
                        Object ext = this.extensionProcessor.read(reader, context);
                        if (namespaceImport == null) break;
                        namespaceImport.getExtensions().add(ext);
                        break;
                    }
                    case 2: {
                        if (!IMPORT.equals(reader.getName())) break;
                        return namespaceImport;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException(e);
            this.error(context.getMonitor(), "XMLStreamException", reader, ex);
        }
        return namespaceImport;
    }

    @Override
    public void write(NamespaceImport namespaceImport, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(IMPORT.getNamespaceURI(), IMPORT.getLocalPart());
        if (namespaceImport.getNamespace() != null) {
            writer.writeAttribute(NAMESPACE, namespaceImport.getNamespace());
        }
        if (namespaceImport.getLocation() != null) {
            writer.writeAttribute(LOCATION, namespaceImport.getLocation());
        }
        this.writeExtendedAttributes(writer, namespaceImport, this.attributeProcessor, context);
        for (Object ext : namespaceImport.getExtensions()) {
            this.extensionProcessor.write(ext, writer, context);
        }
        writer.writeEndElement();
    }

    @Override
    public void resolve(NamespaceImport model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }
}

