/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.namespace.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.contribution.namespace.NamespaceExport;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImportExportFactory;
import org.apache.tuscany.sca.contribution.namespace.impl.NamespaceExportModelResolver;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class NamespaceExportProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<NamespaceExport> {
    private static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    private static final QName EXPORT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "export");
    private static final String NAMESPACE = "namespace";
    private final NamespaceImportExportFactory factory;
    private final AssemblyFactory extensionFactory;
    private final StAXArtifactProcessor<Object> extensionProcessor;
    private final StAXAttributeProcessor<Object> attributeProcessor;

    public NamespaceExportProcessor(FactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> extensionProcessor, StAXAttributeProcessor<Object> attributeProcessor) {
        this.factory = (NamespaceImportExportFactory)modelFactories.getFactory(NamespaceImportExportFactory.class);
        this.extensionFactory = (AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
        this.extensionProcessor = extensionProcessor;
        this.attributeProcessor = attributeProcessor;
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "contribution-namespace-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return EXPORT;
    }

    @Override
    public Class<NamespaceExport> getModelType() {
        return NamespaceExport.class;
    }

    @Override
    public NamespaceExport read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException {
        NamespaceExport namespaceExport = this.factory.createNamespaceExport();
        QName element = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        element = reader.getName();
                        if (EXPORT.equals(element)) {
                            String ns = reader.getAttributeValue(null, NAMESPACE);
                            if (ns == null) {
                                this.error(context.getMonitor(), "AttributeNameSpaceMissing", reader, new Object[0]);
                            } else {
                                namespaceExport.setNamespace(ns);
                            }
                            this.readExtendedAttributes(reader, namespaceExport, this.attributeProcessor, this.extensionFactory, context);
                            break;
                        }
                        Object ext = this.extensionProcessor.read(reader, context);
                        if (namespaceExport == null) break;
                        namespaceExport.getExtensions().add(ext);
                        break;
                    }
                    case 2: {
                        if (!EXPORT.equals(reader.getName())) break;
                        return namespaceExport;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException(e);
            this.error(context.getMonitor(), "XMLStreamException", reader, ex);
        }
        return namespaceExport;
    }

    @Override
    public void write(NamespaceExport namespaceExport, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(EXPORT.getNamespaceURI(), EXPORT.getLocalPart());
        if (namespaceExport.getNamespace() != null) {
            writer.writeAttribute(NAMESPACE, namespaceExport.getNamespace());
        }
        this.writeExtendedAttributes(writer, namespaceExport, this.attributeProcessor, context);
        for (Object ext : namespaceExport.getExtensions()) {
            this.extensionProcessor.write(ext, writer, context);
        }
        writer.writeEndElement();
    }

    @Override
    public void resolve(NamespaceExport namespaceExport, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (namespaceExport.getNamespace() != null) {
            namespaceExport.setModelResolver(new NamespaceExportModelResolver(resolver));
        }
    }
}

