/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.resolver;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolverExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleModelResolver
implements ModelResolver {
    private ExtensionPointRegistry extensionPoints;
    private final ModelResolverExtensionPoint resolverExtensions;
    private final ModelFactoryExtensionPoint modelFactories;
    private final Contribution contribution;
    private ModelResolver defaultResolver;
    private final Map<Class<?>, ModelResolver> resolversByModelType = new HashMap();
    private final Map<Class<?>, ModelResolver> resolversByImplementationClass = new HashMap();
    private Map<Object, Object> map = new HashMap<Object, Object>();
    private Object lastUnresolved;

    @Deprecated
    public ExtensibleModelResolver(Contribution contribution, ExtensionPointRegistry extensionPoints, ModelResolverExtensionPoint resolverExtensions, ModelFactoryExtensionPoint modelFactories, ModelResolver defaultResolver) {
        this.contribution = contribution;
        this.extensionPoints = extensionPoints;
        this.resolverExtensions = resolverExtensions;
        this.modelFactories = modelFactories;
        this.defaultResolver = defaultResolver;
    }

    public ExtensibleModelResolver(Contribution contribution, ExtensionPointRegistry extensionPoints) {
        this.contribution = contribution;
        this.extensionPoints = extensionPoints;
        this.resolverExtensions = (ModelResolverExtensionPoint)extensionPoints.getExtensionPoint(ModelResolverExtensionPoint.class);
        this.modelFactories = (ModelFactoryExtensionPoint)extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
    }

    private ModelResolver getModelResolverInstance(Class<?> modelType) {
        Class<?>[] interfaces = modelType.getInterfaces();
        Class[] classes = new Class[interfaces.length + 1];
        classes[0] = modelType;
        if (interfaces.length != 0) {
            System.arraycopy(interfaces, 0, classes, 1, interfaces.length);
        }
        for (Class c : classes) {
            ModelResolver resolverInstance = this.resolversByModelType.get(c);
            if (resolverInstance != null) {
                return resolverInstance;
            }
            Class<? extends ModelResolver> resolverClass = this.resolverExtensions.getResolver(c);
            if (resolverClass == null) continue;
            resolverInstance = this.resolversByImplementationClass.get(resolverClass);
            if (resolverInstance != null) {
                this.resolversByModelType.put(c, resolverInstance);
                return resolverInstance;
            }
            try {
                try {
                    Constructor<? extends ModelResolver> constructor = resolverClass.getConstructor(Contribution.class, ModelFactoryExtensionPoint.class);
                    if (constructor == null) continue;
                    resolverInstance = constructor.newInstance(this.contribution, this.modelFactories);
                    this.resolversByImplementationClass.put(resolverClass, resolverInstance);
                    this.resolversByModelType.put(c, resolverInstance);
                    return resolverInstance;
                }
                catch (NoSuchMethodException e) {
                    Constructor<? extends ModelResolver> constructor = resolverClass.getConstructor(Contribution.class, ExtensionPointRegistry.class);
                    if (constructor == null) continue;
                    resolverInstance = constructor.newInstance(this.contribution, this.extensionPoints);
                    this.resolversByImplementationClass.put(resolverClass, resolverInstance);
                    this.resolversByModelType.put(c, resolverInstance);
                    return resolverInstance;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    @Override
    public void addModel(Object resolved) {
        ModelResolver resolver = this.getModelResolverInstance(resolved.getClass());
        if (resolver != null) {
            resolver.addModel(resolved);
        } else {
            this.map.put(resolved, resolved);
        }
    }

    @Override
    public Object removeModel(Object resolved) {
        ModelResolver resolver = this.getModelResolverInstance(resolved.getClass());
        if (resolver != null) {
            return resolver.removeModel(resolved);
        }
        return this.map.remove(resolved);
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        if (unresolved == this.lastUnresolved) {
            return unresolved;
        }
        this.lastUnresolved = unresolved;
        ModelResolver resolver = this.getModelResolverInstance(unresolved.getClass());
        if (resolver != null) {
            T resolved = resolver.resolveModel(modelClass, unresolved);
            if (resolved != null && resolved != unresolved) {
                this.lastUnresolved = null;
                return modelClass.cast(resolved);
            }
        } else {
            Object resolved;
            if (this.defaultResolver != null && (resolved = this.defaultResolver.resolveModel(modelClass, unresolved)) != null && resolved != unresolved) {
                this.lastUnresolved = null;
                return modelClass.cast(resolved);
            }
            resolved = this.map.get(unresolved);
            if (resolved != null) {
                this.lastUnresolved = null;
                return modelClass.cast(resolved);
            }
        }
        return unresolved;
    }

    public ModelResolver getDefaultModelResolver() {
        return this.defaultResolver;
    }
}

