/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sca.contribution.processor.ValidationSchemaExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidationSchemaExtensionPoint
implements ValidationSchemaExtensionPoint {
    private List<String> schemas = new ArrayList<String>();
    private boolean loaded;

    @Override
    public void addSchema(String uri) {
        this.schemas.add(uri);
    }

    @Override
    public void removeSchema(String uri) {
        this.schemas.remove(uri);
    }

    private synchronized void loadSchemas() {
        Set schemaDeclarations;
        if (this.loaded) {
            return;
        }
        try {
            schemaDeclarations = ServiceDiscovery.getInstance().getServiceDeclarations("org.apache.tuscany.sca.contribution.processor.ValidationSchema");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        String tuscanyScaXsd = null;
        for (ServiceDeclaration schemaDeclaration : schemaDeclarations) {
            URL url = schemaDeclaration.getResource(schemaDeclaration.getClassName());
            if (url == null) {
                throw new IllegalArgumentException(new FileNotFoundException(schemaDeclaration.getClassName()));
            }
            if (url.toString().contains("tuscany-sca.xsd")) {
                tuscanyScaXsd = url.toString();
                continue;
            }
            this.schemas.add(url.toString());
        }
        if (tuscanyScaXsd != null) {
            this.schemas.add(0, tuscanyScaXsd);
        }
        this.loaded = true;
    }

    @Override
    public List<String> getSchemas() {
        this.loadSchemas();
        return this.schemas;
    }
}

