/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLStreamReader;
import org.apache.tuscany.sca.contribution.processor.ValidationSchemaExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultValidatingXMLInputFactory
extends ValidatingXMLInputFactory {
    private static final Logger logger = Logger.getLogger(DefaultValidatingXMLInputFactory.class.getName());
    private XMLInputFactory inputFactory;
    private ValidationSchemaExtensionPoint schemas;
    private Monitor monitor;
    private boolean initialized;
    private boolean hasSchemas;
    private Schema aggregatedSchema;

    public DefaultValidatingXMLInputFactory(XMLInputFactory inputFactory, ValidationSchemaExtensionPoint schemas, Monitor monitor) {
        this.inputFactory = inputFactory;
        this.schemas = schemas;
        this.monitor = monitor;
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem((Problem)problem);
        }
    }

    private void initializeSchemas() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            List<String> uris = this.schemas.getSchemas();
            int n = uris.size();
            if (n == 0) {
                return;
            }
            this.hasSchemas = true;
            final Source[] sources = new Source[n];
            for (int i = 0; i < n; ++i) {
                InputStream urlStream;
                String uri = uris.get(i);
                final URL url = new URL(uri);
                try {
                    urlStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws IOException {
                            URLConnection connection = url.openConnection();
                            connection.setUseCaches(false);
                            return connection.getInputStream();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    this.error("PrivilegedActionException", url, (IOException)e.getException());
                    throw (IOException)e.getException();
                }
                sources[i] = new StreamSource(urlStream, uri);
            }
            final SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                this.aggregatedSchema = AccessController.doPrivileged(new PrivilegedExceptionAction<Schema>(){

                    @Override
                    public Schema run() throws SAXException {
                        return schemaFactory.newSchema(sources);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                this.error("PrivilegedActionException", schemaFactory, (SAXException)e.getException());
                throw (SAXException)e.getException();
            }
        }
        catch (Error e) {
            logger.log(Level.WARNING, "XML Schema validation is not supported: " + e.getMessage());
        }
        catch (SAXParseException e) {
            IllegalStateException ie = new IllegalStateException(e);
            this.error("IllegalStateException", this.schemas, ie);
            throw ie;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "XML Schema validation is not supported: " + e.getMessage());
        }
    }

    public XMLEventReader createFilteredReader(XMLEventReader arg0, EventFilter arg1) throws XMLStreamException {
        return this.inputFactory.createFilteredReader(arg0, arg1);
    }

    public XMLStreamReader createFilteredReader(XMLStreamReader arg0, StreamFilter arg1) throws XMLStreamException {
        return this.inputFactory.createFilteredReader(arg0, arg1);
    }

    public XMLEventReader createXMLEventReader(InputStream arg0, String arg1) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(arg0, arg1);
    }

    public XMLEventReader createXMLEventReader(InputStream arg0) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(arg0);
    }

    public XMLEventReader createXMLEventReader(Reader arg0) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(arg0);
    }

    public XMLEventReader createXMLEventReader(Source arg0) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(arg0);
    }

    public XMLEventReader createXMLEventReader(String arg0, InputStream arg1) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(arg0, arg1);
    }

    public XMLEventReader createXMLEventReader(String arg0, Reader arg1) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(arg0, arg1);
    }

    public XMLEventReader createXMLEventReader(XMLStreamReader arg0) throws XMLStreamException {
        return this.inputFactory.createXMLEventReader(arg0);
    }

    public XMLStreamReader createXMLStreamReader(InputStream arg0, String arg1) throws XMLStreamException {
        this.initializeSchemas();
        if (this.hasSchemas) {
            return new ValidatingXMLStreamReader(this.inputFactory.createXMLStreamReader(arg0, arg1), this.aggregatedSchema, this.monitor);
        }
        return this.inputFactory.createXMLStreamReader(arg0, arg1);
    }

    public XMLStreamReader createXMLStreamReader(InputStream arg0) throws XMLStreamException {
        this.initializeSchemas();
        if (this.hasSchemas) {
            return new ValidatingXMLStreamReader(this.inputFactory.createXMLStreamReader(arg0), this.aggregatedSchema, this.monitor);
        }
        return this.inputFactory.createXMLStreamReader(arg0);
    }

    public XMLStreamReader createXMLStreamReader(Reader arg0) throws XMLStreamException {
        this.initializeSchemas();
        if (this.hasSchemas) {
            return new ValidatingXMLStreamReader(this.inputFactory.createXMLStreamReader(arg0), this.aggregatedSchema, this.monitor);
        }
        return this.inputFactory.createXMLStreamReader(arg0);
    }

    public XMLStreamReader createXMLStreamReader(Source arg0) throws XMLStreamException {
        this.initializeSchemas();
        if (this.hasSchemas) {
            return new ValidatingXMLStreamReader(this.inputFactory.createXMLStreamReader(arg0), this.aggregatedSchema, this.monitor);
        }
        return this.inputFactory.createXMLStreamReader(arg0);
    }

    public XMLStreamReader createXMLStreamReader(String arg0, InputStream arg1) throws XMLStreamException {
        this.initializeSchemas();
        if (this.hasSchemas) {
            return new ValidatingXMLStreamReader(this.inputFactory.createXMLStreamReader(arg0, arg1), this.aggregatedSchema, this.monitor);
        }
        return this.inputFactory.createXMLStreamReader(arg0, arg1);
    }

    public XMLStreamReader createXMLStreamReader(String arg0, Reader arg1) throws XMLStreamException {
        this.initializeSchemas();
        if (this.hasSchemas) {
            return new ValidatingXMLStreamReader(this.inputFactory.createXMLStreamReader(arg0, arg1), this.aggregatedSchema, this.monitor);
        }
        return this.inputFactory.createXMLStreamReader(arg0, arg1);
    }

    public XMLEventAllocator getEventAllocator() {
        return this.inputFactory.getEventAllocator();
    }

    public Object getProperty(String arg0) throws IllegalArgumentException {
        return this.inputFactory.getProperty(arg0);
    }

    public XMLReporter getXMLReporter() {
        return this.inputFactory.getXMLReporter();
    }

    public XMLResolver getXMLResolver() {
        return this.inputFactory.getXMLResolver();
    }

    public boolean isPropertySupported(String arg0) {
        return this.inputFactory.isPropertySupported(arg0);
    }

    public void setEventAllocator(XMLEventAllocator arg0) {
        this.inputFactory.setEventAllocator(arg0);
    }

    public void setProperty(String arg0, Object arg1) throws IllegalArgumentException {
        this.inputFactory.setProperty(arg0, arg1);
    }

    public void setXMLReporter(XMLReporter arg0) {
        this.inputFactory.setXMLReporter(arg0);
    }

    public void setXMLResolver(XMLResolver arg0) {
        this.inputFactory.setXMLResolver(arg0);
    }
}

